﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/json/pctl_JsonErrorHandler.h>
#include <nn/pctl/pctl_ResultPrivate.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace json {

nn::Result HandleJsonError(RAPIDJSON_NAMESPACE::ParseResult result) NN_NOEXCEPT
{
    if (!result.IsError())
    {
        return nn::ResultSuccess();
    }

    switch (result.Code())
    {
    case RAPIDJSON_NAMESPACE::kParseErrorDocumentEmpty:
        return nn::ResultSuccess();
    case RAPIDJSON_NAMESPACE::kParseErrorDocumentRootNotSingular:
        return ResultJsonDocumentError();
    case RAPIDJSON_NAMESPACE::kParseErrorObjectMissName:
    case RAPIDJSON_NAMESPACE::kParseErrorObjectMissColon:
    case RAPIDJSON_NAMESPACE::kParseErrorObjectMissCommaOrCurlyBracket:
    case RAPIDJSON_NAMESPACE::kParseErrorArrayMissCommaOrSquareBracket:
    case RAPIDJSON_NAMESPACE::kParseErrorStringMissQuotationMark:
    case RAPIDJSON_NAMESPACE::kParseErrorUnspecificSyntaxError:
        return ResultJsonSyntaxError();
    case RAPIDJSON_NAMESPACE::kParseErrorValueInvalid:
    case RAPIDJSON_NAMESPACE::kParseErrorStringUnicodeEscapeInvalidHex:
    case RAPIDJSON_NAMESPACE::kParseErrorStringUnicodeSurrogateInvalid:
    case RAPIDJSON_NAMESPACE::kParseErrorStringEscapeInvalid:
    case RAPIDJSON_NAMESPACE::kParseErrorStringInvalidEncoding:
    case RAPIDJSON_NAMESPACE::kParseErrorNumberTooBig:
    case RAPIDJSON_NAMESPACE::kParseErrorNumberMissFraction:
    case RAPIDJSON_NAMESPACE::kParseErrorNumberMissExponent:
        return ResultJsonContentError();
    case RAPIDJSON_NAMESPACE::kParseErrorTermination:
        return ResultJsonParsingTerminated();
    default:
        return ResultJsonSyntaxError();
    }
}

}}}}}
