﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/json/pctl_JsonApi.h>
#include <nn/pctl/detail/service/json/pctl_JsonDataHandlerProxy.h>
#include <nn/pctl/detail/service/json/pctl_JsonErrorHandler.h>
#include <nn/pctl/pctl_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace json {

nn::Result Parse(JsonDataHandler* pHandler,
    JsonInputStream* pStream,
    const common::Cancelable* pCancelable) NN_NOEXCEPT
{
    JsonDataHandlerProxy proxy;

    proxy.SetHandler(pHandler);
    proxy.SetCancelable(pCancelable);
    proxy.SetOverflowDetector(pStream->GetOverflowDetector());

    pStream->SetCancelable(pCancelable);

    NullAllocator allocator;

    const unsigned int ParseFlags = RAPIDJSON_NAMESPACE::kParseInsituFlag |
        RAPIDJSON_NAMESPACE::kParseStopWhenDoneFlag | RAPIDJSON_NAMESPACE::kParseValidateEncodingFlag;

    RAPIDJSON_NAMESPACE::ParseResult result = JsonReader(&allocator, 1).Parse<ParseFlags>(*pStream, proxy);

    NN_RESULT_THROW_UNLESS(!pCancelable->IsCanceled(), ResultCanceled());

    NN_RESULT_DO(pStream->GetLastError());
    NN_RESULT_DO(detail::service::json::HandleJsonError(result));

    NN_RESULT_SUCCESS;
}

}}}}}
