﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/common/pctl_AsyncContext.h>

#include <nn/pctl/pctl_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace common {

void AsyncContext::CloseContext() NN_NOEXCEPT
{
}

bool AsyncContext::IsFinished(nn::Result* pResult) const NN_NOEXCEPT
{
    if (pResult != nullptr)
    {
        *pResult = m_Result;
    }
    return m_IsFinished;
}


nn::Result AsyncContext::InitializeSystemEvent() NN_NOEXCEPT
{
    auto result = nn::os::CreateSystemEvent(&m_SystemEvent, nn::os::EventClearMode_ManualClear, true);
    NN_RESULT_THROW_UNLESS(result.IsSuccess(), nn::pctl::ResultOutOfMemory());
    m_IsSystemEventInitialized = true;
    NN_RESULT_SUCCESS;
}

}}}}}
