﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/pctl_Authenticator.h>

#include <nn/la/la_Auth.h>
#include <nn/pctl/pctl_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace pctl { namespace detail {

nn::Result ShowAuthenticatorForConfiguration() NN_NOEXCEPT
{
    nn::la::auth::ParentalAuthenticationArg arg;

    arg.SetDefault();
    arg.isTemporary = true;
    arg.skipEnterRestrictedSystemSettings = true;

    auto result = nn::la::auth::ShowParentalAuthentication(arg);

    // 異常終了のABORTは la 内で行われるため、Success 以外は ResultConfigurationCanceled とする
    NN_RESULT_THROW_UNLESS(result.IsSuccess(), nn::pctl::ResultConfigurationCanceled());

    NN_RESULT_SUCCESS;
}

}}}
