﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.pcm
{
    // 基本インタフェース群
    [CppRefPath("<nn/pcm/pcm_IManager.sfdl.h>")]
    interface IManager : IServiceObject
    {
        [MethodId(0)]
        Result IsSupported(Out<bool> isBoardSupported, int32_t point);

        [MethodId(1)]
        Result ReadCurrentPower(Out<int_t> power, int32_t point);

        [MethodId(2)]
        Result IsServiceEnabled(Out<bool> isServiceEnabled);

        [MethodId(3)]
        Result ReadCurrentVoltage(Out<int_t> voltage, int32_t point);
    }
}
