﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/pcm/driver/pcm_Api.h>
#include <nn/pcm/driver/pcm_Suspend.h>

namespace nn {
namespace pcm {
namespace driver {

void Initialize() NN_NOEXCEPT
{
}

void Finalize() NN_NOEXCEPT
{
}

bool IsServiceEnabled() NN_NOEXCEPT
{
    return true;
}

bool IsSupported(MeasuringPoint point) NN_NOEXCEPT
{
    NN_UNUSED(point);
    return true;
}

int ReadCurrentPower(MeasuringPoint point) NN_NOEXCEPT
{
    NN_UNUSED(point);
    return 0;
}

int ReadCurrentVoltage(MeasuringPoint point) NN_NOEXCEPT
{
    NN_UNUSED(point);
    return 0;
}

void SuspendAllMeasuringPoints() NN_NOEXCEPT
{
}

void ResumeAllMeasuringPoints() NN_NOEXCEPT
{
}

} // driver
} // pcm
} // nn
