﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/dd.h>

#include <nn/sf/impl/sf_StaticOneAllocator.h>
#include <nn/sf/impl/sf_ExpHeapAllocator.h>

#include "../detail/pcie_Memory.h"
#include "../detail/pcie_ILoggedStateManager.h"

namespace nn { namespace pcie { namespace server {

class LoggedStateManagerImpl
    : public nn::sf::ISharedObject
{
public:
    LoggedStateManagerImpl() NN_NOEXCEPT;
    ~LoggedStateManagerImpl() NN_NOEXCEPT;
    nn::Result GetLoggedState(const nn::sf::OutBuffer& output, nn::sf::Out<bool> isLoggedErrorPending, bool isCleared) NN_NOEXCEPT;
    nn::Result GetLoggedStateEvent(nn::sf::Out<nn::sf::NativeHandle> loggedStateEventHandle, bool isStatisticReported) NN_NOEXCEPT;
    void DoLoggedStateCallback(bool isDueToError) NN_NOEXCEPT;
private:
    bool                                 m_IsLoggedStateStatisticsReported;
    bool                                 m_IsLoggedErrorPending;
    nn::os::SystemEvent                  m_LoggedStateEvent;

    static void LoggedStateCallback(uintptr_t context, bool isDueToError)
    {
        LoggedStateManagerImpl* pThis = reinterpret_cast<LoggedStateManagerImpl*>(context);
        if(pThis != nullptr)
        {
            pThis->DoLoggedStateCallback(isDueToError);
        }
    }
};


} // namespace server
} // namespace pci
} // namespace nn
