﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    pci_TK1.h
 * @brief   NVIDIA Tegra K1 PCIe Specific Definitions and
 *          Constants
 */

namespace nn { namespace pcie { namespace driver { namespace detail {

// Physical I/O Regions
enum NvPhysIo
{
    NvPhysIo_PcieA1Addr     = 0x01000000,
    NvPhysIo_PcieA1Size     = 0x02000000,

    NvPhysIo_PcieA2Addr     = 0x02000000,
    NvPhysIo_PcieA2Size     = 0x05000000,

    NvPhysIo_PcieA3Addr     = 0x10000000,
    NvPhysIo_PcieA3Size     = 0x04000000,

    NvPhysIo_PinMuxAuxAddr  = 0x70003000,
    NvPhysIo_PinMuxAuxSize  = 0x1000,

    NvPhysIo_RtcAddr        = 0x7000e000,
    NvPhysIo_RtcSize        = 0x1000,

    NvPhysIo_XusbPadctlAddr = 0x7009F000,
    NvPhysIo_XusbPadctlSize = 0x1000,
};

// PHY Registers
#define NN_PCI_XUSB_PADCTL_ELPG_PROGRAM_0_REG         (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x01c))
#define NN_PCI_XUSB_PADCTL_ELPG_PROGRAM_1_0_REG       (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x024))
#define NN_PCI_XUSB_PADCTL_USB3_PAD_MUX_REG           (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x028))
#define NN_PCI_XUSB_PADCTL_IOPHY_PLL_P0_CTL1_REG      (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x040))
#define NN_PCI_XUSB_PADCTL_IOPHY_PLL_P0_CTL2_REG      (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x044))
#define NN_PCI_XUSB_PADCTL_IOPHY_PLL_S0_CTL1_REG      (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x138))
#define NN_PCI_XUSB_PADCTL_IOPHY_MISC_PAD_S0_CTL1_REG (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x148))
#define NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_REG    (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x360))
#define NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_2_0_REG    (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x364))
#define NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_3_0_REG    (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x368))
#define NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_REG    (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x36c))
#define NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_5_0_REG    (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x370))
#define NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_6_0_REG    (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x374))
#define NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_7_0_REG    (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x378))
#define NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_REG    (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x37c))
#define NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_9_0_REG    (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x380))
#define NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_10_0_REG   (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x384))
#define NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_11_0_REG   (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x388))
#define NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_12_0_REG   (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x38c))
#define NN_PCI_XUSB_PADCTL_UPHY_MISC_PAD_P0_CTL_2_0_REG (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x464))
#define NN_PCI_XUSB_PADCTL_UPHY_MISC_PAD_P1_CTL_2_0_REG (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x4A4))
#define NN_PCI_XUSB_PADCTL_UPHY_MISC_PAD_P2_CTL_2_0_REG (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x4E4))
#define NN_PCI_XUSB_PADCTL_UPHY_MISC_PAD_P3_CTL_2_0_REG (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x524))
#define NN_PCI_XUSB_PADCTL_UPHY_MISC_PAD_P4_CTL_2_0_REG (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x564))
#define NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_P0_CTL_8_0_REG (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x47C))
#define NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_P1_CTL_8_0_REG (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x4BC))
#define NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_P2_CTL_8_0_REG (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x4FC))
#define NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_P3_CTL_8_0_REG (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x53C))
#define NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_P4_CTL_8_0_REG (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x57C))
#define NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_P5_CTL_8_0_REG (*reinterpret_cast<volatile uint32_t *>(m_XusbPadctlBase + 0x5BC))


// PMC Registers
#define NN_PCI_APBDEV_PMC_CLAMP_STATUS_REG            (*reinterpret_cast<volatile uint32_t *>(m_PmcBase + 0x2c))
#define NN_PCI_APBDEV_PMC_PWRGATE_TOGGLE_REG          (*reinterpret_cast<volatile uint32_t *>(m_PmcBase + 0x30))
#define NN_PCI_APBDEV_PMC_REMOVE_CLAMPING_CMD_REG     (*reinterpret_cast<volatile uint32_t *>(m_PmcBase + 0x34))
#define NN_PCI_APBDEV_PMC_PWRGATE_STATUS_REG          (*reinterpret_cast<volatile uint32_t *>(m_PmcBase + 0x38))
#define NN_PCI_APBDEV_PMC_GLB_AMAP_CFG_REG            (*reinterpret_cast<volatile uint32_t *>(m_PmcBase + 0x2bc))

// PINMUX Aux
#define NN_PCI_PINMUX_AUX_PEX_L0_RST_N_0_REG          (*reinterpret_cast<volatile uint32_t *>(m_PinMuxAuxBase + 0x038))
#define NN_PCI_PINMUX_AUX_PEX_L0_CLKREQ_N_0_REG       (*reinterpret_cast<volatile uint32_t *>(m_PinMuxAuxBase + 0x03c))
#define NN_PCI_PINMUX_AUX_PEX_WAKE_N_0_REG            (*reinterpret_cast<volatile uint32_t *>(m_PinMuxAuxBase + 0x040))
#define NN_PCI_PINMUX_AUX_PEX_L1_RST_N_0_REG          (*reinterpret_cast<volatile uint32_t *>(m_PinMuxAuxBase + 0x044))
#define NN_PCI_PINMUX_AUX_PEX_L1_CLKREQ_N_0_REG       (*reinterpret_cast<volatile uint32_t *>(m_PinMuxAuxBase + 0x048))

// PCIe PADS
#define NN_PCI_PADS_REFCLK_CFG0  (*reinterpret_cast<volatile uint32_t *>(m_PciePadsBase + 0xC8))
#define NN_PCI_PADS_REFCLK_CFG1  (*reinterpret_cast<volatile uint32_t *>(m_PciePadsBase + 0xCC))
#define NN_PCI_PADS_REFCLK_BIAS  (*reinterpret_cast<volatile uint32_t *>(m_PciePadsBase + 0xD0))

// AFI
#define NN_PCI_AFI_AXI_BAR0_SZ_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x00))
#define NN_PCI_AFI_AXI_BAR1_SZ_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x04))
#define NN_PCI_AFI_AXI_BAR2_SZ_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x08))
#define NN_PCI_AFI_AXI_BAR3_SZ_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x0c))
#define NN_PCI_AFI_AXI_BAR4_SZ_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x10))
#define NN_PCI_AFI_AXI_BAR5_SZ_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x14))
#define NN_PCI_AFI_AXI_BAR6_SZ_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x134))
#define NN_PCI_AFI_AXI_BAR7_SZ_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x138))
#define NN_PCI_AFI_AXI_BAR8_SZ_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x13c))
//
#define NN_PCI_AFI_AXI_BAR0_START_REG     (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x18))
#define NN_PCI_AFI_AXI_BAR1_START_REG     (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x1c))
#define NN_PCI_AFI_AXI_BAR2_START_REG     (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x20))
#define NN_PCI_AFI_AXI_BAR3_START_REG     (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x24))
#define NN_PCI_AFI_AXI_BAR4_START_REG     (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x28))
#define NN_PCI_AFI_AXI_BAR5_START_REG     (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x2c))
#define NN_PCI_AFI_AXI_BAR6_START_REG     (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x140))
#define NN_PCI_AFI_AXI_BAR7_START_REG     (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x144))
#define NN_PCI_AFI_AXI_BAR8_START_REG     (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x148))
//
#define NN_PCI_AFI_FPCI_BAR0_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x30))
#define NN_PCI_AFI_FPCI_BAR1_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x34))
#define NN_PCI_AFI_FPCI_BAR2_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x38))
#define NN_PCI_AFI_FPCI_BAR3_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x3c))
#define NN_PCI_AFI_FPCI_BAR4_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x40))
#define NN_PCI_AFI_FPCI_BAR5_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x44))
#define NN_PCI_AFI_FPCI_BAR6_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x14c))
#define NN_PCI_AFI_FPCI_BAR7_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x150))
#define NN_PCI_AFI_FPCI_BAR8_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x154))
//
#define NN_PCI_AFI_MSI_BAR_SZ_REG         (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x60))
#define NN_PCI_AFI_MSI_FPCI_BAR_ST_REG    (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x64))
#define NN_PCI_AFI_MSI_AXI_BAR_ST_REG     (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x68))
#define NN_PCI_AFI_MSI_VEC0_REG           (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x6c))
#define NN_PCI_AFI_MSI_VEC1_REG           (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x70))
#define NN_PCI_AFI_MSI_VEC2_REG           (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x74))
#define NN_PCI_AFI_MSI_VEC3_REG           (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x78))
#define NN_PCI_AFI_MSI_VEC4_REG           (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x7c))
#define NN_PCI_AFI_MSI_VEC5_REG           (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x80))
#define NN_PCI_AFI_MSI_VEC6_REG           (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x84))
#define NN_PCI_AFI_MSI_VEC7_REG           (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x88))
#define NN_PCI_AFI_MSI_EN_VEC0_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x8c))
#define NN_PCI_AFI_MSI_EN_VEC1_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x90))
#define NN_PCI_AFI_MSI_EN_VEC2_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x94))
#define NN_PCI_AFI_MSI_EN_VEC3_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x98))
#define NN_PCI_AFI_MSI_EN_VEC4_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x9c))
#define NN_PCI_AFI_MSI_EN_VEC5_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0xa0))
#define NN_PCI_AFI_MSI_EN_VEC6_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0xa4))
#define NN_PCI_AFI_MSI_EN_VEC7_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0xa8))
//
#define NN_PCI_AFI_CONFIGURATION_REG      (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x0ac))
#define NN_PCI_AFI_FPCI_ERROR_MASKS_REG   (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x0b0))
#define NN_PCI_AFI_INTR_MASK_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x0b4))
#define NN_PCI_AFI_INTR_CODE_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x0b8))
#define NN_PCI_AFI_INTR_SIGNATURE_REG     (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x0bc))
#define NN_PCI_AFI_UPPER_FPCI_ADDR_REG    (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x0c0))
#define NN_PCI_AFI_SM_INTR_ENABLE_REG     (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x0c4))
#define NN_PCI_AFI_AFI_INTR_ENABLE_REG    (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x0c8))
#define NN_PCI_AFI_PCIE_PME_REG           (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x0f0))
#define NN_PCI_AFI_PCIE_CONFIG_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x0f8))
#define NN_PCI_AFI_FUSE_REG               (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x104))
#define NN_PCI_AFI_PEX0_CTRL_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x110))
#define NN_PCI_AFI_PEX1_CTRL_REG          (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x118))
#define NN_PCI_AFI_PEX0_STATUS_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x114))
#define NN_PCI_AFI_PEX1_STATUS_REG        (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x11c))
#define NN_PCI_AFI_PLLE_CONTROL_REG       (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x160))
#define NN_PCI_AFI_PEXBIAS_CTRL_REG       (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x168))
//
#define NN_PCI_AFI_MSG_REG                (*reinterpret_cast<volatile uint32_t *>(m_PcieAfiBase + 0x190))

enum TK1RegisterValues
{
    // CLK_RST_CONTROLLER_PLLE_SS_CNTL
    PLLE_SS_INCINTRV_SHIFT     = 24,
    PLLE_SS_INCINTRV_MASK      = (0x3f << PLLE_SS_INCINTRV_SHIFT),
    PLLE_SS_INC_SHIFT          = 16,
    PLLE_SS_INC_MASK           = (0xff << PLLE_SS_INC_SHIFT),
    PLLE_SS_CNTL_INVERT        = (0x1 << 15),
    PLLE_SS_CNTL_CENTER        = (0x1 << 14),
    PLLE_SS_CNTL_SSC_BYP       = (0x1 << 12),
    PLLE_SS_CNTL_INTERP_RESET  = (0x1 << 11),
    PLLE_SS_CNTL_BYPASS_SS     = (0x1 << 10),
    PLLE_SS_MAX_SHIFT          = 0,
    PLLE_SS_MAX_MASK           = (0x1ff << PLLE_SS_MAX_SHIFT),
    PLLE_SS_COEFFICIENTS_MASK  = (PLLE_SS_INCINTRV_MASK | PLLE_SS_INC_MASK | PLLE_SS_MAX_MASK),
    PLLE_SS_COEFFICIENTS_VAL   = ((0x23 << PLLE_SS_INCINTRV_SHIFT) | (0x1 << PLLE_SS_INC_SHIFT) | (0x21 << PLLE_SS_MAX_SHIFT)),
    PLLE_SS_DISABLE            = (PLLE_SS_CNTL_SSC_BYP | PLLE_SS_CNTL_INTERP_RESET | PLLE_SS_CNTL_BYPASS_SS),

    // CLK_RST_CONTROLLER_PLLE_BASE
    PLLE_BASE_ENABLE        = (1 << 31),
    PLLE_BASE_LOCK_OVERRIDE = (1 << 30),
    PLLE_BASE_DIVCML_SHIFT  = 24,
    PLLE_BASE_DIVCML_MASK   = (0x1F << PLLE_BASE_DIVCML_SHIFT),
    PLLE_BASE_DIVN_SHIFT    = 8,
    PLLE_BASE_DIVN_MASK     = (0xFF << PLLE_BASE_DIVN_SHIFT),
    PLLE_BASE_DIVM_SHIFT    = 0,
    PLLE_BASE_DIVM_MASK     = (0xFF << PLLE_BASE_DIVM_SHIFT),

    // CLK_RST_CONTROLLER_PLLE_MISC
    PLLE_MISC_IDDQ_SW_CTRL       = (1 << 14),
    PLLE_MISC_IDDQ_SW_VALUE      = (1 << 13),
    PLLE_MISC_LOCK               = (1 << 11),
    PLLE_MISC_LOCK_ENABLE        = (1 << 9),
    PLLE_MISC_PLLE_PTS           = (1 << 8),
    PLLE_MISC_VREG_BG_CTRL_SHIFT = 4,
    PLLE_MISC_VREG_BG_CTRL_MASK  = (0x3 << PLLE_MISC_VREG_BG_CTRL_SHIFT),
    PLLE_MISC_VREG_CTRL_SHIFT    = 2,
    PLLE_MISC_VREG_CTRL_MASK     = (0x3 << PLLE_MISC_VREG_CTRL_SHIFT),

    // CLK_RST_CONTROLLER_PLLE_AUX_REG
    PLLE_AUX_SS_SEQ_INCLUDE   = (1 << 31),
    PLLE_AUX_PLLRE_SEL        = (1 << 28),
    PLLE_AUX_SEQ_STATE_SHIFT  = 26,
    PLLE_AUX_SEQ_STATE_MASK   = (0x3 << PLLE_AUX_SEQ_STATE_SHIFT),
    PLLE_AUX_SEQ_START_STATE  = (1 << 25),
    PLLE_AUX_SEQ_ENABLE       = (1 << 24),
    PLLE_LOCK_DLY_SHIFT       = 8,
    PLLE_LOCK_DLY_MASK        = (0xff << PLLE_LOCK_DLY_SHIFT),
    PLLE_AUX_SS_SWCTL         = (1 << 6),
    PLLE_AUX_CONFIG_SWCTL     = (1 << 5),
    PLLE_AUX_ENABLE_SWCTL     = (1 << 4),
    PLLE_AUX_USE_LOCKDET      = (1 << 3),
    PLLE_AUX_PLLP_SEL         = (1 << 2),
    PLLE_AUX_CML_SATA_ENABLE  = (1 << 1),
    PLLE_AUX_CML_PCIE_ENABLE  = (1 << 0),

    // NN_PCI_XUSB_PADCTL_ELPG_PROGRAM_1_0_REG
    NN_PCI_XUSB_PADCTL_ELPG_PROGRAM_1_0_AUX_MUX_LP0_VCORE_DOWN      = (1 << 31),
    NN_PCI_XUSB_PADCTL_ELPG_PROGRAM_1_0_AUX_MUX_LP0_CLAMP_EN_EARLY  = (1 << 30),
    NN_PCI_XUSB_PADCTL_ELPG_PROGRAM_1_0_AUX_MUX_LP0_CLAMP_EN        = (1 << 29),

    // NN_PCI_XUSB_PADCTL_ELPG_PROGRAM_0_REG
    XUSB_PADCTL_ELPG_PROGRAM_0_AUX_MUX_LP0_VCORE_DOWN     = (1 << 26),
    XUSB_PADCTL_ELPG_PROGRAM_0_AUX_MUX_LP0_CLAMP_EN_EARLY = (1 << 25),
    XUSB_PADCTL_ELPG_PROGRAM_0_AUX_MUX_LP0_CLAMP_EN       = (1 << 24),

    // NN_PCI_XUSB_PADCTL_USB3_PAD_MUX_REG
    XUSB_PADCTL_USB3_PAD_MUX_PCIE_IDDQ_DISABLE_LANE0_SHIFT = 1,
    XUSB_PADCTL_USB3_PAD_MUX_PCIE_IDDQ_DISABLE_LANE1_SHIFT = 2,
    XUSB_PADCTL_USB3_PAD_MUX_PCIE_IDDQ_DISABLE_LANE2_SHIFT = 3,
    XUSB_PADCTL_USB3_PAD_MUX_PCIE_IDDQ_DISABLE_LANE3_SHIFT = 4,
    XUSB_PADCTL_USB3_PAD_MUX_PCIE_IDDQ_DISABLE_LANE4_SHIFT = 5,
    XUSB_PADCTL_USB3_PAD_MUX_PCIE_IDDQ_DISABLE_LANE5_SHIFT = 6,
    XUSB_PADCTL_USB3_PAD_MUX_PCIE_IDDQ_DISABLE_LANE6_SHIFT = 7,
    XUSB_PADCTL_USB3_PAD_MUX_ASSIGN_LANE0_SHIFT            = 12,
    XUSB_PADCTL_USB3_PAD_MUX_ASSIGN_LANE1_SHIFT            = 14,
    XUSB_PADCTL_USB3_PAD_MUX_ASSIGN_LANE2_SHIFT            = 16,
    XUSB_PADCTL_USB3_PAD_MUX_ASSIGN_LANE3_SHIFT            = 18,
    XUSB_PADCTL_USB3_PAD_MUX_ASSIGN_LANE4_SHIFT            = 20,
    XUSB_PADCTL_USB3_PAD_MUX_ASSIGN_LANE5_SHIFT            = 22,
    XUSB_PADCTL_USB3_PAD_MUX_ASSIGN_LANE6_SHIFT            = 24,
    XUSB_PADCTL_USB3_PAD_MUX_ASSIGN_LANE_SATA_SHIFT        = 30,

    // NN_PCI_XUSB_PADCTL_IOPHY_PLL_P0_CTL1_REG
    XUSB_PADCTL_IOPHY_PLL_P0_CTL1_PLL0_LOCKDET          = (1 << 19),
    XUSB_PADCTL_IOPHY_PLL_P0_CTL1_REFCLK_SEL_MASK       = (0xf << 12),
    XUSB_PADCTL_IOPHY_PLL_P0_CTL1_PLL_RST               = (1 << 1),

    // NN_PCI_XUSB_PADCTL_IOPHY_PLL_P0_CTL2_REG
    XUSB_PADCTL_IOPHY_PLL_P0_CTL2_REFCLKBUF_EN          = (1 << 6),
    XUSB_PADCTL_IOPHY_PLL_P0_CTL2_TXCLKREF_EN           = (1 << 5),
    XUSB_PADCTL_IOPHY_PLL_P0_CTL2_TXCLKREF_SEL          = (1 << 4),

    // NN_PCI_XUSB_PADCTL_IOPHY_PLL_S0_CTL1_REGPADCTL_IOPHY_PLL_P0_CTL2_REG
    XUSB_PADCTL_IOPHY_PLL_S0_CTL1_PLL1_LOCKDET          = (1 << 27),
    XUSB_PADCTL_IOPHY_PLL_S0_CTL1_PLL1_MODE             = (1 << 24),
    XUSB_PADCTL_IOPHY_PLL_S0_CTL1_PLL_PWR_OVRD          = (1 << 3),
    XUSB_PADCTL_IOPHY_PLL_S0_CTL1_PLL_SLEEP             = (3 << 1),
    XUSB_PADCTL_IOPHY_PLL_S0_CTL1_PLL_RST               = (1 << 1),
    XUSB_PADCTL_IOPHY_PLL_S0_CTL1_PLL_IDDQ              = (1 << 0),

    //NN_PCI_XUSB_PADCTL_IOPHY_MISC_PAD_S0_CTL1_REG
    XUSB_PADCTL_IOPHY_MISC_PAD_S0_CTL1_IDDQ_OVRD        = (1 << 1),
    XUSB_PADCTL_IOPHY_MISC_PAD_S0_CTL1_IDDQ             = (1 << 0),

    // XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_REG
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_FREQ_PSDIV_SHIFT = 28,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_FREQ_PSDIV_MASK  = (3 << XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_FREQ_PSDIV_SHIFT),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_FREQ_NDIV_SHIFT  = 20,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_FREQ_NDIV_MASK   = (0xff << XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_FREQ_NDIV_SHIFT),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_FREQ_MDIV_SHIFT  = 16,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_FREQ_MDIV_MASK   = (3 << XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_FREQ_MDIV_SHIFT),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_LOCKDET_STATUS   = (1 << 15),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_MODE_SHIFT       = 8,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_MODE_MASK        = (3 << XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_MODE_SHIFT),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_BYPASS_EN        = (1 << 7),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_FREERUN_EN       = (1 << 6),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_PWR_OVRD         = (1 << 4),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_ENABLE           = (1 << 3),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_SLEEP_SHIFT      = 1,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_SLEEP_MASK       = (3 << XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_SLEEP_SHIFT),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_1_0_PLL0_IDDQ             = (1 << 0),

    // XUSB_PADCTL_UPHY_PLL_P0_CTL_2_0_REG
    XUSB_PADCTL_UPHY_PLL_P0_CTL_2_0_PLL0_CAL_CTRL_SHIFT = 4,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_2_0_PLL0_CAL_CTRL_MASK  = 0x0FFFFFF0,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_2_0_PLL0_CAL_RESET      = (1 << 3),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_2_0_PLL0_CAL_OVRD       = (1 << 2),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_2_0_PLL0_CAL_DONE       = (1 << 1),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_2_0_PLL0_CAL_EN         = (1 << 0),

    // XUSB_PADCTL_UPHY_PLL_P0_CTL_3_0_REG
    XUSB_PADCTL_UPHY_PLL_P0_CTL_3_0_PLL0_LOCKDET_CTRL_SHIFT = 4,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_3_0_PLL0_LOCKDET_CTRL_MASK  = 0x0FFFFFF0,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_3_0_PLL0_LOCKDET_RESET      = (1 << 0),

    // XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_REG
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_TCLKOUT_EN         = (1 << 28),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_CLKDIST_CTRL_SHIFT = 20,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_CLKDIST_CTRL_MASK  = 0x00F00000,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_XDIGCLK_EN         = (1 << 19),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_XDIGCLK_SEL_SHIFT  = 18,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_XDIGCLK_SEL_MASK   = 0x00070000,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_TXCLKREF_EN        = (1 << 15),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_TXCLKREF_SEL_SHIFT = 12,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_TXCLKREF_SEL_MASK  = 0x00003000,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_FBCLKBUF_EN        = (1 << 9),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_REFCLKBUF_EN       = (1 << 8),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_REFCLK_SEL_SHIFT   = 4,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_REFCLK_SEL_MASK    = 0x000000F0,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_4_0_PLL0_REFCLK_TERM100     = (1 << 0),

    // XUSB_PADCTL_UPHY_PLL_P0_CTL_5_0_REG
    XUSB_PADCTL_UPHY_PLL_P0_CTL_5_0_PLL0_DC0_CTRL_SHIFT     = 16,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_5_0_PLL0_DC0_CTRL_MASK      = 0x00FF0000,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_5_0_PLL0_LPF_CTRL_SHIFT     = 8,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_5_0_PLL0_LPF_CTRL_MASK      = 0x0000FF00,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_5_0_PLL0_CP_CTRL_SHIFT      = 4,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_5_0_PLL0_CP_CTRL_MASK       = 0x000000F0,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_5_0_PLL0_PFD_CTRL_SHIFT     = 0,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_5_0_PLL0_PFD_CTRL_MASK      = 0x00000003,

    // XUSB_PADCTL_UPHY_PLL_P0_CTL_6_0_REG
    XUSB_PADCTL_UPHY_PLL_P0_CTL_6_0_PLL0_FSEL_LOAD         = (1 << 31),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_6_0_PLL0_FSEL_COARSE_OVRD  = (1 << 29),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_6_0_PLL0_FSEL_FINE_OVRD    = (1 << 28),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_6_0_PLL0_FSEL_COARSE_SHIFT = 20,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_6_0_PLL0_FSEL_COARSE_MASK  = 0x00000000,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_6_0_PLL0_FSEL_FINE_SHIFT   = 0,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_6_0_PLL0_FSEL_FINE_MASK    = 0x000FFFFF,

    // XUSB_PADCTL_UPHY_PLL_P0_CTL_7_0_REG
    XUSB_PADCTL_UPHY_PLL_P0_CTL_7_0_PLL0_FSEL_FINE_SHIFT   = 0,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_7_0_PLL0_FSEL_FINE_MASK    = 0x00FFFFFF,

    // XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_REG
    XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_RCAL_DONE         = (1 << 31),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_RCAL_VAL_SHIFT    = 24,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_RCAL_VAL_MASK     = 0x1f << XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_RCAL_VAL_SHIFT,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_RCAL_BYP_EN       = (1 << 23),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_RCAL_BYP_CODE_SHIFT = 16,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_RCAL_BYP_CODE_MASK  = 0x1f << XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_RCAL_BYP_CODE_SHIFT,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_RCAL_OVRD          = (1 << 15),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_RCAL_CLK_EN        = (1 << 13),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_RCAL_EN            = (1 << 12),
    XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_BGAP_CTRL_SHIFT    = 0,
    XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_BGAP_CTRL_MASK     = (0xfff << XUSB_PADCTL_UPHY_PLL_P0_CTL_8_0_PLL0_BGAP_CTRL_SHIFT),

    // NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_10_0_REG
    NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_10_0_CFG_WDATA_SHIFT = 0,
    NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_10_0_CFG_WDATA_MASK  = 0xffff << NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_10_0_CFG_WDATA_SHIFT,
    NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_10_0_CFG_ADDR_SHIFT  = 16,
    NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_10_0_CFG_ADDR_MASK   = 0xff << NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_10_0_CFG_ADDR_SHIFT,
    NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_10_0_CFG_WS_MASK     = 1 << 24,
    NN_PCI_XUSB_PADCTL_UPHY_PLL_P0_CTL_10_0_CFG_RESET_MASK  = 1 << 27,

    // NN_PCI_XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_2_0_REG
    XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_2_0_RX_PWR_OVRD        = (1 << 25),
    XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_2_0_TX_PWR_OVRD        = (1 << 24),
    XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_2_0_RX_IDDQ_OVRD       = (1 << 9),
    XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_2_0_RX_IDDQ            = (1 << 8),
    XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_2_0_RX_SLEEP           = (1 << 13) | (1 << 12),
    XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_2_0_TX_SLEEP           = (1 << 5) | (1 << 4),
    XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_2_0_TX_IDDQ_OVRD       = (1 << 1),
    XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_2_0_TX_IDDQ            = (1 << 0),
    XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_2_0_OVRDS              = 0x03000202,
    XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_2_0_IDDQS              = 0x00000101,

    // NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_8_0_REG
    NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_8_0_CFG_WDATA_SHIFT = 0,
    NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_8_0_CFG_WDATA_MASK  = 0xffff << NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_8_0_CFG_WDATA_SHIFT,
    NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_8_0_CFG_ADDR_SHIFT  = 16,
    NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_8_0_CFG_ADDR_MASK   = 0xff << NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_8_0_CFG_ADDR_SHIFT,
    NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_8_0_CFG_WS_MASK     = 1 << 24,
    NN_PCIE_XUSB_PADCTL_UPHY_MISC_PAD_PX_CTL_8_0_CFG_RESET_MASK  = 1 << 27,

    // APBDEV_PMC_CLAMP_STATUS_REG
    // APBDEV_PMC_REMOVE_CLAMPING_CMD_REG
    APBDEV_PMC_CLAMP_PCI_BIT                            = 3,


    // NN_PCI_APBDEV_PMC_PWRGATE_TOGGLE_REG_PADCTL_IOPHY_MISC_PAD_S0_CTL1_REG
    // NN_PCI_APBDEV_PMC_PWRGATE_STATUS_REG
    APBDEV_PMC_PWRGATE_PCI_BIT                          = 3,
    APBDEV_PMC_PWRGATE_TOGGLE_START                     = (1 << 8),

    // NN_PCI_APBDEV_PMC_GLB_AMAP_CFG_REG
    APBDEV_PMC_GLB_AMAP_CFG_PCIE_A3_DRAM                = (1 << 3),
    APBDEV_PMC_GLB_AMAP_CFG_PCIE_A2_DRAM                = (1 << 2),
    APBDEV_PMC_GLB_AMAP_CFG_PCIE_A1_DRAM                = (1 << 1),

    //NN_PCI_PINMUX_AUX_PEX_L0_RST_N_0_REG
    //NN_PCI_PINMUX_AUX_PEX_L1_RST_N_0_REG
    PINMUX_AUX_PEX_LX_RST_N_0_E_SCHMT         = (1 << 12),
    PINMUX_AUX_PEX_LX_RST_N_0_E_OD            = (1 << 11),
    PINMUX_AUX_PEX_LX_RST_N_0_E_IO_HV         = (1 << 10),
    PINMUX_AUX_PEX_LX_RST_N_0_E_LPDR          = (1 << 8),
    PINMUX_AUX_PEX_LX_RST_N_0_E_LOCK          = (1 << 7),
    PINMUX_AUX_PEX_LX_RST_N_0_E_INPUT         = (1 << 6),
    PINMUX_AUX_PEX_LX_RST_N_0_PARK            = (1 << 5),
    PINMUX_AUX_PEX_LX_RST_N_0_TRISTATE        = (1 << 4),
    PINMUX_AUX_PEX_LX_RST_N_0_PUPD_SHIFT      = 2,
    PINMUX_AUX_PEX_LX_RST_N_0_PUPD_MASK       = (3 << PINMUX_AUX_PEX_LX_RST_N_0_PUPD_SHIFT),
    PINMUX_AUX_PEX_LX_RST_N_0_PM_SHIFT        = 0,
    PINMUX_AUX_PEX_LX_RST_N_0_PM_MASK         = (3 << PINMUX_AUX_PEX_LX_RST_N_0_PM_SHIFT),

    //NN_PCI_PINMUX_AUX_PEX_L0_CLKREQ_N_0_REG
    //NN_PCI_PINMUX_AUX_PEX_L1_CLKREQ_N_0_REG
    PINMUX_AUX_PEX_LX_CLKREQ_N_0_E_SCHMT      = (1 << 12),
    PINMUX_AUX_PEX_LX_CLKREQ_N_0_E_OD         = (1 << 11),
    PINMUX_AUX_PEX_LX_CLKREQ_N_0_E_IO_HV      = (1 << 10),
    PINMUX_AUX_PEX_LX_CLKREQ_N_0_E_LPDR       = (1 << 8),
    PINMUX_AUX_PEX_LX_CLKREQ_N_0_E_LOCK       = (1 << 7),
    PINMUX_AUX_PEX_LX_CLKREQ_N_0_E_INPUT      = (1 << 6),
    PINMUX_AUX_PEX_LX_CLKREQ_N_0_PARK         = (1 << 5),
    PINMUX_AUX_PEX_LX_CLKREQ_N_0_TRISTATE     = (1 << 4),
    PINMUX_AUX_PEX_LX_CLKREQ_N_0_PUPD_SHIFT   = 2,
    PINMUX_AUX_PEX_LX_CLKREQ_N_0_PUPD_MASK    = (3 << PINMUX_AUX_PEX_LX_CLKREQ_N_0_PUPD_SHIFT),
    PINMUX_AUX_PEX_LX_CLKREQ_N_0_PM_SHIFT     = 0,
    PINMUX_AUX_PEX_LX_CLKREQ_N_0_PM_MASK      = (3 << PINMUX_AUX_PEX_LX_CLKREQ_N_0_PM_SHIFT),

    //NN_PCI_PINMUX_AUX_PEX_WAKE_N_0_REG
    PINMUX_AUX_PEX_WAKE_N_0_TRISTATE          = (1 << 4),
    PINMUX_AUX_PEX_WAKE_N_0_PARK              = (1 << 5),


    // AFI
    //   This is a map of  FPCI Bus Layout(AFI Address Space)
    //   0x0000_0000_0000_0000 0x0000_00fc_ffff_ffff 1012  GB Memory-Mapped I/O
    //   0x0000_00fd_fc00_0000 0x0000_00fd_fdff_ffff   32  MB I/O
    //   0x0000_00fd_fe00_0000 0x0000_00fd_feff_ffff   16  MB Type 0 Configuration
    //   0x0000_00fd_ff00_0000 0x0000_00fd_ffff_ffff   16  MB Type 1 Configuration
    //   0x0000_00fe_0000_0000 0x0000_00fe_0fff_ffff   256 MB Type 0 Extended Configuration
    //   0x0000_00fe_1000_0000 0x0000_00fe_1fff_ffff   256 MB Type 1 Extended Configuration
    //   0x0000_0100_0000_0000 0xffff_ffff_ffff_ffff  ~16  EB Memory-Mapped I/O
    AFI_AXI_BAR_SZ_SHIFT                                = 12,
    AFI_FPCI_BAR_TYPE1_EXT_CFG                          = 0xFE100000,
    AFI_FPCI_BAR_MMMIO_CFG                              = 0xFDFC0000,

    // NN_PCI_AFI_CONFIGURATION_REG
    AFI_CONFIGURATION_EN_FPCI                           = (1 << 0),
    AFI_CONFIGURATION_CLKEN_OVERRIDE                    = (1 << 31),
    // NN_PCI_AFI_INTR_MASK_REG
    AFI_INTR_MASK_INT_MASK                              = (1 << 0),
    AFI_INTR_MASK_MSI_MASK                              = (1 << 8),
    // NN_PCI_AFI_SM_INTR_ENABLE_REG
    AFI_SM_INTR_INTA_ASSERT                             = (1 << 0),
    AFI_SM_INTR_INTB_ASSERT                             = (1 << 1),
    AFI_SM_INTR_INTC_ASSERT                             = (1 << 2),
    AFI_SM_INTR_INTD_ASSERT                             = (1 << 3),
    AFI_SM_INTR_INT_ALL_ASSERT                          = 0x0f,
    AFI_SM_INTR_INTA_DEASSERT                           = (1 << 4),
    AFI_SM_INTR_INTB_DEASSERT                           = (1 << 5),
    AFI_SM_INTR_INTC_DEASSERT                           = (1 << 6),
    AFI_SM_INTR_INTD_DEASSERT                           = (1 << 7),
    AFI_SM_INTR_INT_ALL_DEASSERT                        = 0xf0,
    AFI_SM_MAX_INTR_VECTORS                             = 4,
    // NN_PCI_AFI_AFI_INTR_ENABLE_REG
    AFI_INTR_EN_INI_SLVERR                              = (1 << 0),
    AFI_INTR_EN_INI_DECERR                              = (1 << 1),
    AFI_INTR_EN_TGT_SLVERR                              = (1 << 2),
    AFI_INTR_EN_TGT_DECERR                              = (1 << 3),
    AFI_INTR_EN_TGT_WRERR                               = (1 << 4),
    AFI_INTR_EN_DFPCI_DECERR                            = (1 << 5),
    AFI_INTR_EN_AXI_DECERR                              = (1 << 6),
    AFI_INTR_EN_FPCI_TIMEOUT                            = (1 << 7),
    AFI_INTR_EN_PE_PRSNT_SENSE                          = (1 << 8),
    AFI_INTR_EN_PE_CLKREQ_SENSE                         = (1 << 9),
    AFI_INTR_EN_CLKCLAMP_SENSE                          = (1 << 10),
    AFI_INTR_EN_RDY4PD_SENSE                            = (1 << 11),
    AFI_INTR_EN_P2P_ERR                                 = (1 << 12),

    //NN_PCI_AFI_INTR_CODE_REG
    AFI_INTR_CODE_MASK                                  = 0x1f,
    AFI_INTR_CODE_INI_SLVERR                            = 1,
    AFI_INTR_CODE_INI_DECERR                            = 2,
    AFI_INTR_CODE_TGT_SLVERR                            = 3,
    AFI_INTR_CODE_TGT_DECERR                            = 4,
    AFI_INTR_CODE_TGT_WRERR                             = 5,
    AFI_INTR_CODE_SM_MSG                                = 6,
    AFI_INTR_CODE_DFPCI_DECERR                          = 7,
    AFI_INTR_CODE_FPCI_TIMEOUT                          = 8,
    AFI_INTR_CODE_PE_PRSNT_SENSE                        = 10,
    AFI_INTR_CODE_PE_CLKREQ_SENSE                       = 11,
    AFI_INTR_CODE_CLKCLAMP_SENSE                        = 12,
    AFI_INTR_CODE_RDY4PD_SENSE                          = 13,
    AFI_INTR_P2P_ERROR                                  = 14,
    // NN_PCI_AFI_INTR_SIGNATURE_REG
    AFI_INTR_SIGNATURE_DIR_READ_MASK                    = (1 << 0),

    // NN_PCI_AFI_MSG_REG
    AFI_MSG_1_PCIE_FATAL_ERROR_MASK                     = (1 << 31),
    AFI_MSG_1_PCIE_NONFATAL_ERROR_MASK                  = (1 << 30),
    AFI_MSG_1_PCIE_CORRECTABLE_ERROR_MASK               = (1 << 29),
    AFI_MSG_1_PCIE_ROOT_PORT_INTERRUPT_MASK             = (1 << 28),
    AFI_MSG_1_PCIE_INTERRUPT_D_MASK                     = (1 << 27),
    AFI_MSG_1_PCIE_INTERRUPT_C_MASK                     = (1 << 26),
    AFI_MSG_1_PCIE_INTERRUPT_B_MASK                     = (1 << 25),
    AFI_MSG_1_PCIE_INTERRUPT_A_MASK                     = (1 << 24),
    AFI_MSG_1_PCIE_INTERRUPT_ALL_MASK                   = (0xf << 24),
    AFI_MSG_1_HOTPLUG_MASK                              = (1 << 23),
    AFI_MSG_1_ENDPOINT_PME_MASK                         = (1 << 20),
    AFI_MSG_1_MASK                                      = 0xFF900000,
    AFI_MSG_0_PCIE_FATAL_ERROR_MASK                     = (1 << 15),
    AFI_MSG_0_PCIE_NONFATAL_ERROR_MASK                  = (1 << 14),
    AFI_MSG_0_PCIE_CORRECTABLE_ERROR_MASK               = (1 << 13),
    AFI_MSG_0_PCIE_ROOT_PORT_INTERRUPT_MASK             = (1 << 12),
    AFI_MSG_0_PCIE_INTERRUPT_D_MASK                     = (1 << 11),
    AFI_MSG_0_PCIE_INTERRUPT_C_MASK                     = (1 << 10),
    AFI_MSG_0_PCIE_INTERRUPT_B_MASK                     = (1 << 9),
    AFI_MSG_0_PCIE_INTERRUPT_A_MASK                     = (1 << 8),
    AFI_MSG_0_PCIE_INTERRUPT_ALL_MASK                   = (0xf << 8),
    AFI_MSG_0_HOTPLUG_MASK                              = (1 << 7),
    AFI_MSG_0_ENDPOINT_PME_MASK                         = (1 << 4),
    AFI_MSG_0_MASK                                      = 0x0000FF90,

    // NN_PCI_AFI_PCIE_PME_REG
    AFI_PCIE_PME_TURN_OFF                               = 0x101,
    AFI_PCIE_PME_ACK                                    = 0x420,
    // NN_PCI_AFI_PCIE_CONFIG_REG
    AFI_PCIE_CONFIG_PCIE_DISABLE_ALL                    = 0xe,
    AFI_PCIE_CONFIG_SM2TMS0_XBAR_CONFIG_MASK            = (0xf << 20),
    AFI_PCIE_CONFIG_SM2TMS0_XBAR_CONFIG_SINGLE          = (0x0 << 20),
    AFI_PCIE_CONFIG_SM2TMS0_XBAR_CONFIG_420             = (0x0 << 20),
    AFI_PCIE_CONFIG_SM2TMS0_XBAR_CONFIG_X2_X1           = (0x0 << 20),
    AFI_PCIE_CONFIG_SM2TMS0_XBAR_CONFIG_DUAL            = (0x1 << 20),
    AFI_PCIE_CONFIG_SM2TMS0_XBAR_CONFIG_222             = (0x1 << 20),
    AFI_PCIE_CONFIG_SM2TMS0_XBAR_CONFIG_X4_X1           = (0x1 << 20),
    AFI_PCIE_CONFIG_SM2TMS0_XBAR_CONFIG_411             = (0x2 << 20),
    // NN_PCI_AFI_FUSE_REG
    AFI_FUSE_PCIE_T0_GEN2_DIS                           = (1 << 2),
    //NN_PCI_AFI_PEX0_CTRL_REG
    //NN_PCI_AFI_PEX1_CTRL_REG
    AFI_PEX_CTRL_RST_L                                  = (1 << 0),
    AFI_PEX_CTRL_CLKREQ_EN                              = (1 << 1),
    AFI_PEX_CTRL_REFCLK_EN                              = (1 << 3),
    AFI_PEX_CTRL_REFCLK_OVR_EN                          = (1 << 4),
    //NN_PCI_AFI_PEX0_STATUS_REG
    //NN_PCI_AFI_PEX1_STATUS_REG
    AFI_PEX_STATUS_CLKREQ                               = (1 << 0),
    //NN_PCI_AFI_PLLE_CONTROL_REG
    AFI_PLLE_CONTROL_BYPASS_PADS2PLLE_CONTROL           = (1 << 9),
    AFI_PLLE_CONTROL_BYPASS_PCIE2PLLE_CONTROL           = (1 << 8),
    AFI_PLLE_CONTROL_PADS2PLLE_CONTROL_EN               = (1 << 1),
    AFI_PLLE_CONTROL_PCIE2PLLE_CONTROL_EN               = (1 << 0),

    // NN_PCI_AFI_PEXBIAS_CTRL_REG
    AFI_PEXBIAS_CTRL_PWRD                               = (1 << 0),

    // AFI MSI
    AFI_MSI_VEC_REGISTERS                               = 8,
    AFI_MSI_VECTORS_PER_REGISTER                        = 32,
    AFI_MSI_VECTORS_PER_REGISTER_POWEROFTWO             = 5,
    AFI_MSI_TOTAL_VECTORS                               = AFI_MSI_VECTORS_PER_REGISTER * AFI_MSI_VEC_REGISTERS,

    // AFI INT
    AFI_INT_TOTAL_VECTORS                               = 4,

    // Extended configuration space(per-port)
    T_PCIE2_RP_INTR_BCR_OFFSET                          = 0x03C,
    RP_INTR_BCR_INTR_LINE_SHIFT                         = 0,
    RP_INTR_BCR_INTR_LINE_MASK                          = 0xff << RP_INTR_BCR_INTR_LINE_SHIFT,
    T_PCIE2_RP_LINK_CONTROL_STATUS_2_OFFSET             = 0x0B0,
    RP_LINK_CONTROL_STATUS_2_TARGET_LINK_GEN1_MASK      = 1,
    RP_LINK_CONTROL_STATUS_2_TARGET_LINK_GEN2_MASK      = 2,
    T_PCIE2_RP_PRIV_XP_DL_OFFSET                        = 0x494,
    RP_PRIV_XP_DL_GEN2_UPD_FC_TSHOLD                    = 0x1FF << 1,
    T_PCIE2_RP_RSR_OFFSET                               = 0xA0,
    RP_RSR_PMESTAT_MASK                                 = (1 << 15),
    T_PCIE2_RP_L1_PM_SUBSTATES_CYA_OFFSET               = 0xC00,
    RP_L1_PM_SUBSTATES_CYA_CM_RTIME_SHIFT               = 8,
    RP_L1_PM_SUBSTATES_CYA_CM_RTIME_MASK                = 0xFF << RP_L1_PM_SUBSTATES_CYA_CM_RTIME_SHIFT,
    RP_L1_PM_SUBSTATES_CYA_T_PWRN_SCL_SHIFT             = 16,
    RP_L1_PM_SUBSTATES_CYA_T_PWRN_SCL_MASK              = 0x3 << RP_L1_PM_SUBSTATES_CYA_T_PWRN_SCL_SHIFT,
    RP_L1_PM_SUBSTATES_CYA_T_PWRN_VAL_SHIFT             = 19,
    RP_L1_PM_SUBSTATES_CYA_T_PWRN_VAL_MASK              = 0xF8 << RP_L1_PM_SUBSTATES_CYA_T_PWRN_VAL_SHIFT,
    T_PCIE2_RP_L1_PM_SUBSTATES_1_CYA_OFFSET             = 0xC04,
    RP_L1_PM_SUBSTATES_1_CYA_PWR_OFF_DLY_SHIFT          = 0,
    RP_L1_PM_SUBSTATES_1_CYA_PWR_OFF_DLY_MASK           = 0x1FFF << RP_L1_PM_SUBSTATES_1_CYA_PWR_OFF_DLY_SHIFT,
    RP_L1_PM_SUBSTATES_1_CYA_CLKREQ_ASSERTED_DLY_SHIFT  = 13,
    RP_L1_PM_SUBSTATES_1_CYA_CLKREQ_ASSERTED_DLY_MASK   = 0x1FF << RP_L1_PM_SUBSTATES_1_CYA_CLKREQ_ASSERTED_DLY_SHIFT,
    T_PCIE2_RP_L1_PM_SUBSTATES_2_CYA_OFFSET             = 0xC08,
    RP_L1_PM_SUBSTATES_2_CYA_T_L1_2_DLY_SHIFT           = 0,
    RP_L1_PM_SUBSTATES_2_CYA_T_L1_2_DLY_MASK            = 0x1FFF << RP_L1_PM_SUBSTATES_2_CYA_T_L1_2_DLY_SHIFT,
    RP_L1_PM_SUBSTATES_2_CYA_MICROSECOND_SHIFT          = 13,
    RP_L1_PM_SUBSTATES_2_CYA_MICROSECOND_MASK           = 0xFF << RP_L1_PM_SUBSTATES_2_CYA_MICROSECOND_SHIFT,
    RP_L1_PM_SUBSTATES_2_CYA_MICROSECOND_COMP_SHIFT     = 21,
    RP_L1_PM_SUBSTATES_2_CYA_MICROSECOND_COMP_MASK      = 0xF << RP_L1_PM_SUBSTATES_2_CYA_MICROSECOND_COMP_SHIFT,
    T_PCIE2_RP_LTR_REP_VAL_OFFSET                       = 0xC10,
    T_PCIE2_RP_L1_1_ENTRY_COUNT_OFFSET                  = 0xC14,
    T_PCIE2_RP_L1_1_ENTRY_COUNT_RESET_SHIFT             = 31,
    T_PCIE2_RP_L1_1_ENTRY_COUNT_FREEZE_SHIFT            = 30,
    T_PCIE2_RP_L1_1_ENTRY_COUNT_MASK                    = 0xffff,
    T_PCIE2_RP_L1_2_ENTRY_COUNT_OFFSET                  = 0xC18,
    T_PCIE2_RP_L1_2_ENTRY_COUNT_RESET_SHIFT             = 31,
    T_PCIE2_RP_L1_2_ENTRY_COUNT_FREEZE_SHIFT            = 30,
    T_PCIE2_RP_L1_2_ENTRY_COUNT_MASK                    = 0xffff,
    T_PCIE2_RP_L1_2_ABORT_COUNT_OFFSET                  = 0xC1C,
    T_PCIE2_RP_RX_HDR_LIMIT_OFFSET                      = 0xE00,
    RP_RX_HDR_LIMIT_PW_MASK                             = 0xFF00,
    RP_RX_HDR_LIMIT_PW                                  = 0x0E << 8,
    T_PCIE2_RP_TX_HDR_LIMIT_OFFSET                      = 0xE08,
    RP_TX_HDR_LIMIT_NPT_0                               = 32,
    RP_TX_HDR_LIMIT_NPT_1                               = 4,
    T_PCIE2_RP_UFPCI_OFFSET                             = 0xE10,
    T_PCIE2_RP_TIMEOUT0_OFFSET                          = 0xE24,
    RP_TIMEOUT0_PAD_SPDCHNG_GEN2_SHIFT                  = 24,
    RP_TIMEOUT0_PAD_SPDCHNG_GEN2_MASK                   = (0xFF << 24),
    RP_TIMEOUT0_PAD_PWRUP_CM_SHIFT                      = 8,
    RP_TIMEOUT0_PAD_PWRUP_CM_MASK                       = (0xffff << RP_TIMEOUT0_PAD_PWRUP_CM_SHIFT),
    RP_TIMEOUT0_PAD_PWRUP_SHIFT                         = 0,
    RP_TIMEOUT0_PAD_PWRUP_MASK                          = (0xff << RP_TIMEOUT0_PAD_PWRUP_SHIFT),
    T_PCIE2_RP_TIMEOUT1_OFFSET                          = 0xE28,
    RP_TIMEOUT1_RCVRY_SPD_UNSUCCESS_EIDLE_SHIFT         = 24,
    RP_TIMEOUT1_RCVRY_SPD_UNSUCCESS_EIDLE_MASK          = (0xFF << RP_TIMEOUT1_RCVRY_SPD_UNSUCCESS_EIDLE_SHIFT),
    RP_TIMEOUT1_RCVRY_SPD_SUCCESS_EIDLE_SHIFT           = 16,
    RP_TIMEOUT1_RCVRY_SPD_SUCCESS_EIDLE_MASK            = (0xff << RP_TIMEOUT1_RCVRY_SPD_SUCCESS_EIDLE_SHIFT),
    RP_TIMEOUT1_PAD_SPDCHNG_GEN1_SHIFT                  = 0,
    RP_TIMEOUT1_PAD_SPDCHNG_GEN1_MASK                   = (0xFFFF << RP_TIMEOUT1_PAD_SPDCHNG_GEN1_SHIFT),
    T_PCIE2_RP_ECTL_2_R1_0_OFFSET                       = 0xE84,
    T_PCIE2_RP_ECTL_4_R1_0_OFFSET                       = 0xE8C,
    T_PCIE2_RP_ECTL_5_R1_0_OFFSET                       = 0xE90,
    T_PCIE2_RP_ECTL_6_R1_0_OFFSET                       = 0xE94,
    T_PCIE2_RP_ECTL_2_R2_0_OFFSET                       = 0xEA4,
    T_PCIE2_RP_ECTL_4_R2_0_OFFSET                       = 0xEAC,
    T_PCIE2_RP_ECTL_5_R2_0_OFFSET                       = 0xEB0,
    T_PCIE2_RP_ECTL_6_R2_0_OFFSET                       = 0xEB4,
    T_PCIE2_RP_VEND_XP_OFFSET                           = 0xF00,
    RP_VEND_XP_DL_UP                                    = (1 << 30),
    RP_VEND_XP_OPPORTUNISTIC_UPDATEFC                   = (1 << 28),
    RP_VEND_XP_OPPORTUNISTIC_ACK                        = (1 << 27),
    RP_VEND_XP1_LINK_PVT_CTL_L1_ASPM_SUPPORT            = (1 << 21),
    RP_VEND_XP_UPDATE_FC_THRESHOLD_SHIFT                = 18,
    RP_VEND_XP_UPDATE_FC_THRESHOLD_MASK                 = 0xFF << RP_VEND_XP_UPDATE_FC_THRESHOLD_SHIFT,
    T_PCIE2_RP_VEND_XP1_OFFSET                          = 0xF04,
    T_PCIE2_RP_LINK_CONTROL_STATUS_OFFSET               = 0x090,
    RP_LINK_CONTROL_STATUS_DL_LINK_ACTIVE               = 0x20000000,
    RP_LINK_CONTROL_STATUS_SPEED_MASK                   = 0x000F0000,
    RP_LINK_CONTROL_STATUS_SPEED_SHIFT                  = 16,
    T_PCIE2_RP_VEND_CTL0_OFFSET                         = 0x00000F44,
    RP_VEND_CTL0_DSK_RST_PULSE_WIDTH_SHIFT              = 12,
    RP_VEND_CTL0_DSK_RST_PULSE_WIDTH_MASK               = 0xF << RP_VEND_CTL0_DSK_RST_PULSE_WIDTH_SHIFT,
    T_PCIE2_RP_XP_REF_OFFSET                            = 0xF30,
    RP_XP_REF_MICROSECOND_LIMIT_SHIFT                   = 0,
    RP_XP_REF_MICROSECOND_LIMIT_MASK                    = 0xFF << RP_XP_REF_MICROSECOND_LIMIT_SHIFT,
    RP_XP_REF_MICROSECOND_SHIFT                         = 8,
    RP_XP_REF_MICROSECOND_MASK                          = 1 << RP_XP_REF_MICROSECOND_SHIFT,
    RP_XP_REF_CPL_TO_OVERRIDE_SHIFT                     = 13,
    RP_XP_REF_CPL_TO_OVERRIDE_MASK                      = 1 << RP_XP_REF_CPL_TO_OVERRIDE_SHIFT,
    RP_XP_REF_CPL_TO_CUSTOM_VALUE_SHIFT                 = 14,
    RP_XP_REF_CPL_TO_CUSTOM_VALUE_MASK                  = 0x1FFFF << RP_XP_REF_CPL_TO_CUSTOM_VALUE_SHIFT,
    T_PCIE2_RP_VEND_CTL1_OFFSET                         = 0xF48,
    RP_VEND_CTL1_ERPT_SHIFT                             = 13,
    RP_VEND_CTL1_ERPT_MASK                              = 1 << RP_VEND_CTL1_ERPT_SHIFT,
    T_PCIE2_RP_VEND_XP_BIST_OFFSET                      = 0xF4C,
    RP_VEND_XP_BIST_GOTO_L1_L2_AFTER_DLLP_DONE          = (1 << 28),
    T_PCIE2_RP_VEND_XP_PAD_PWRDN_OFFSET                 = 0xF50,
    RP_VEND_XP_PAD_PWRDN_L1_SHIFT                       = 0,
    RP_VEND_XP_PAD_PWRDN_L1_MASK                        = (1 << RP_VEND_XP_PAD_PWRDN_L1_SHIFT),
    RP_VEND_XP_PAD_PWRDN_DYNAMIC_SHIFT                  = 1,
    RP_VEND_XP_PAD_PWRDN_DYNAMIC_MASK                   = (1 << RP_VEND_XP_PAD_PWRDN_DYNAMIC_SHIFT),
    RP_VEND_XP_PAD_PWRDN_DISABLED_SHIFT                 = 2,
    RP_VEND_XP_PAD_PWRDN_DISABLED_MASK                  = (1 << RP_VEND_XP_PAD_PWRDN_DISABLED_SHIFT),
    RP_VEND_XP_PAD_PWRDN_L1_CLKREQ_SHIFT                = 15,
    RP_VEND_XP_PAD_PWRDN_L1_CLKREQ_MASK                 = (1 << RP_VEND_XP_PAD_PWRDN_L1_CLKREQ_SHIFT),
    RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_DYNAMIC_SHIFT       = 5,
    RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_DYNAMIC_MASK        = (3 << RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_DYNAMIC_SHIFT),
    RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_L1_SHIFT            = 3,
    RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_L1_MASK             = (3 << RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_L1_SHIFT),
    RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_L1_CLKREQ_SHIFT     = 16,
    RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_L1_CLKREQ_MASK      = (3 << RP_VEND_XP_PAD_PWRDN_SLEEP_MODE_L1_CLKREQ_SHIFT),
    T_PCIE2_RP_PRIV_XP_RX_L0S_ENTRY_COUNT_OFFSET        = 0xF8C,
    T_PCIE2_RP_PRIV_XP_TX_L0S_ENTRY_COUNT_OFFSET        = 0xF90,
    T_PCIE2_RP_PRIV_XP_L1_ENTRY_COUNT_OFFSET            = 0xF94,
    T_PCIE2_RP_VEND_CTL2_OFFSET                         = 0xFA8,
    VEND_CTL2_PCA_ENABLE                                = (1 << 7),
    T_PCIE2_RP_PRIV_MISC_OFFSET                         = 0xFE0,
    RP_PRIV_MISC_TMS_CLK_CLAMP_ENABLE                   = (1 << 31),
    RP_PRIV_MISC_CTLR_CLK_CLAMP_ENABLE                  = (1 << 23),
    RP_PRIV_MISC_TMS_CLK_CLAMP_THRESHOLD_SHIFT          = 24,
    RP_PRIV_MISC_TMS_CLK_CLAMP_THRESHOLD_MASK           = (0x7F << RP_PRIV_MISC_TMS_CLK_CLAMP_THRESHOLD_SHIFT),
    RP_PRIV_MISC_CTLR_CLK_CLAMP_THRESHOLD_SHIFT         = 16,
    RP_PRIV_MISC_CTLR_CLK_CLAMP_THRESHOLD_MASK          = (0x7F << RP_PRIV_MISC_CTLR_CLK_CLAMP_THRESHOLD_SHIFT),
    RP_PRIV_MISC_PRSNT_MAP_EP_SHIFT                     = 0,
    RP_PRIV_MISC_PRSNT_MAP_EP_MASK                      = 0xF << RP_PRIV_MISC_PRSNT_MAP_EP_SHIFT,
    T_PCIE2_RP_XP_CTL_1_OFFSET                          = 0xFEC,
    RP_XP_CTL_1_SPARE_BIT29                             = (1 << 29),
    RP_XP_CTL_1_CYA_SHIFT                               = 28,
    RP_XP_CTL_1_CYA_MASK                                = (7 << RP_XP_CTL_1_CYA_SHIFT),
    T_PCIE2_RP_ECTL_1_R2_OFFSET                         = 0xFD8,
    RP_ECTL_1_R2_TX_CMADJ_1C                            = (0xD << 8),
    RP_ECTL_1_R2_TX_DRV_CNTL_1C                         = (0x3 << 28),

};

} // end of namespace detail
} // end of namespace driver
} // end of namespace pcie
} // end of namespace nn




