﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/omm/srv/omm_CradleLedController.h>

namespace nn { namespace omm { namespace srv {

    void CradleLedController::Initialize(const usb::pd::CradleSession& session, ConsoleStyle consoleStyle) NN_NOEXCEPT
    {
        m_Session = session;
        m_ConsoleStyle = consoleStyle;
    }

    CradleLedController::~CradleLedController() NN_NOEXCEPT
    {
    }

    void CradleLedController::On() NN_NOEXCEPT
    {
        if (m_ConsoleStyle == ConsoleStyle::ConsoleAndHandheld)
        {
            usb::pd::Vdo vdo;
            vdo.Set<usb::pd::VdmLed::Brightness>(128);
            vdo.Set<usb::pd::VdmLed::OnTime>(20);
            vdo.Set<usb::pd::VdmLed::OffTime>(0);
            vdo.Set<usb::pd::VdmLed::DelayTime>(0);
            usb::pd::SetCradleVdo(&(*m_Session), &vdo, usb::pd::CradleVdmCommand_Led);
        }
    }

    void CradleLedController::Off() NN_NOEXCEPT
    {
        if (m_ConsoleStyle == ConsoleStyle::ConsoleAndHandheld)
        {
            usb::pd::Vdo vdo;
            vdo.Set<usb::pd::VdmLed::Brightness>(0);
            vdo.Set<usb::pd::VdmLed::OnTime>(0);
            vdo.Set<usb::pd::VdmLed::OffTime>(0);
            vdo.Set<usb::pd::VdmLed::DelayTime>(0);
            usb::pd::SetCradleVdo(&(*m_Session), &vdo, usb::pd::CradleVdmCommand_Led);
        }
    }

}}}
