﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/omm/detail/omm_Log.h>
#include "omm_Utility.h"

#if defined NN_BUILD_CONFIG_SPEC_NX && defined NN_BUILD_CONFIG_OS_HORIZON
#include <nn/apm/apm_SystemApi.h>
#include <nn/tc/tc_OperatingMode.h>
#include <nn/tcap/tcap_OperationMode.h>
#include <nn/btm/btm_Api.h>
#endif

namespace nn { namespace omm { namespace srv { namespace detail {

    void SetTcOperatingMode(OperationMode mode)
    {
#if defined NN_BUILD_CONFIG_SPEC_NX && defined NN_BUILD_CONFIG_OS_HORIZON
        tc::OperatingMode tcMode = (mode == OperationMode::Console) ? tc::OperatingMode_Console : tc::OperatingMode_Handheld;
        NN_ABORT_UNLESS_RESULT_SUCCESS(tc::SetOperatingMode(tcMode));

        auto tcapMode = (mode == OperationMode::Console) ? tcap::OperationMode_Console : tcap::OperationMode_Handheld;
        tcap::SetOperationMode(tcapMode);
#else
        NN_UNUSED(mode);
#endif
    }

    void SetApmPerformanceMode(OperationMode mode)
    {
#if defined NN_BUILD_CONFIG_SPEC_NX && defined NN_BUILD_CONFIG_OS_HORIZON
        apm::PerformanceMode apmMode = (mode == OperationMode::Console) ? apm::PerformanceMode_Boost : apm::PerformanceMode_Normal;
        apm::RequestPerformanceMode(apmMode);
#else
        NN_UNUSED(mode);
#endif
    }

    void EnableBtmRadio()
    {
#if defined NN_BUILD_CONFIG_SPEC_NX && defined NN_BUILD_CONFIG_OS_HORIZON
        nn::btm::EnableRadio(true);
#endif
    }

}}}}
