﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.omm
{
    [CppRefPath(@"<nn/omm/omm_Api.h>")]
    [ExternalStruct(1, 1)]
    public struct OperationMode {}

    [CppRefPath(@"<nn/omm/omm_Api.h>")]
    [ExternalStruct(1, 1)]
    public struct CradleStatus { }

    [CppRefPath(@"<nn/omm/omm_Api.h>")]
    [ExternalStruct(1, 1)]
    public struct OperationModePolicy { }

    [CppRefPath(@"<nn/omm/omm_Api.h>")]
    [ExternalStruct(1, 1)]
    public struct HdcpState { }
}

namespace nn.omm.detail
{
    public interface IOperationModeManager : IServiceObject
    {
        [MethodId(0)]
        Result GetOperationMode(Out<OperationMode> outValue);

        [MethodId(1)]
        Result GetOperationModeChangeEvent(Out<NativeHandle> outValue);

        [MethodId(2)]
        Result EnableAudioVisual();

        [MethodId(3)]
        Result DisableAudioVisual();

        [MethodId(4)]
        Result EnterSleepAndWait(NativeHandle handle);

        [MethodId(5)]
        Result GetCradleStatus(Out<CradleStatus> outValue);

        [MethodId(6)]
        Result FadeInDisplay();

        [MethodId(7)]
        Result FadeOutDisplay();

        [MethodId(8)]
        Result GetCradleFwVersion(Out<uint32_t> outPdcH, Out<uint32_t> outPdcA, Out<uint32_t> outMcu, Out<uint32_t> outDp2Hdmi);

        [MethodId(9)]
        Result NotifyCecSettingsChanged();

        [MethodId(10)]
        Result SetOperationModePolicy(OperationModePolicy policy);

        [MethodId(11)]
        Result GetDefaultDisplayResolution(Out<int32_t> outWidth, Out<int32_t> outHeight);

        [MethodId(12)]
        Result GetDefaultDisplayResolutionChangeEvent(Out<NativeHandle> outValue);

        [MethodId(13)]
        Result UpdateDefaultDisplayResolution();

        [MethodId(14)]
        Result ShouldSleepOnBoot(Out<bool> pOut);

        [MethodId(15)]
        Result NotifyHdcpApplicationExecutionStarted();

        [MethodId(16)]
        Result NotifyHdcpApplicationExecutionFinished();

        [MethodId(17)]
        Result NotifyHdcpApplicationDrawingStarted();

        [MethodId(18)]
        Result NotifyHdcpApplicationDrawingFinished();

        [MethodId(19)]
        Result GetHdcpAuthenticationFailedEvent(Out<NativeHandle> outValue);

        [MethodId(20)]
        Result GetHdcpAuthenticationFailedEmulationEnabled(Out<bool> pOut);

        [MethodId(21)]
        Result SetHdcpAuthenticationFailedEmulation(bool enable);

        [MethodId(22)]
        Result GetHdcpStateChangeEvent(Out<NativeHandle> outValue);

        [MethodId(23)]
        Result GetHdcpState(Out<HdcpState> outValue);

        [MethodId(24)]
        Result ShowCardUpdateProcessing();

        [MethodId(25)]
        Result SetApplicationCecSettingsAndNotifyChanged(int mode);

    }
}
