﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nn/olsc/detail/olsc_Log.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/srv/util/olsc_MountManager.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_StringUtil.h>

namespace nn { namespace olsc { namespace srv { namespace util {

DefaultMountManager::DefaultMountManager(const MountInfo& deviceSaveInfo, const MountInfo& userSttingSaveInfo, const MountInfo& userSeriesInfoSaveInfo) NN_NOEXCEPT
{
    RegisterTag(DefaultSaveDataTag::DeviceSave, deviceSaveInfo);
    RegisterTag(DefaultSaveDataTag::UserSettingsSave, userSttingSaveInfo);
    RegisterTag(DefaultSaveDataTag::UserSeriesInfoSave, userSeriesInfoSaveInfo);
}

ReadMount DefaultMountManager::AcquireDeviceSaveForRead() NN_NOEXCEPT
{
    return AcquireForRead(DefaultSaveDataTag::DeviceSave, account::InvalidUid);
}

WriteMount DefaultMountManager::AcquireDeviceSaveForWrite() NN_NOEXCEPT
{
    return AcquireForWrite(DefaultSaveDataTag::DeviceSave, account::InvalidUid);
}

ReadMount DefaultMountManager::AcquireUserSettingsSaveForRead(const account::Uid& uid) NN_NOEXCEPT
{
    return AcquireForRead(DefaultSaveDataTag::UserSettingsSave, uid);
}

WriteMount DefaultMountManager::AcquireUserSettingsSaveForWrite(const account::Uid& uid) NN_NOEXCEPT
{
    return AcquireForWrite(DefaultSaveDataTag::UserSettingsSave, uid);
}

ReadMount DefaultMountManager::AcquireUserSeriesInfoSaveForRead(const account::Uid& uid) NN_NOEXCEPT
{
    return AcquireForRead(DefaultSaveDataTag::UserSeriesInfoSave, uid);
}

WriteMount DefaultMountManager::AcquireUserSeriesInfoSaveForWrite(const account::Uid& uid) NN_NOEXCEPT
{
    return AcquireForWrite(DefaultSaveDataTag::UserSeriesInfoSave, uid);
}



}}}} //namespace nn::olsc::srv::util
