﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/http/json/http_JsonPath.h>
#include <nn/http/stream/http_CurlInputStream.h>
#include <nn/nn_Result.h>
#include <nn/olsc/srv/adaptor/olsc_AdaptorBase.h>
#include "../adaptor/olsc_OutputStream.h"
#include <nn/olsc/srv/olsc_InternalTypes.h>
#include <nn/fs/fs_SaveDataTransferForCloudBackUp.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace olsc { namespace srv { namespace transfer {

class UploaderBase
    : http::stream::WebApiAccessorBase
{
private:
    Result m_IoResult {ResultSuccess()};

    CURLM* m_CurlMulti {nullptr};

    struct
    {
        std::atomic<bool> stored;
        const void* address;
        size_t total;
        size_t used;
    } m_BufferInfo {{false}, nullptr, 0u, 0u};
    size_t m_OutputOffset {0u};

    static size_t ReadFunction(char* ptr, size_t unitBytes, size_t count, void* pContext) NN_NOEXCEPT;

    Result FinalizeImpl() NN_NOEXCEPT;
    Result ExtractMultiPerformError(CURLM* curlMulti) NN_NOEXCEPT;

public:
    UploaderBase(CURL* curlHandle, const nn::util::Cancelable* pCancelable = nullptr) NN_NOEXCEPT;
    ~UploaderBase() NN_NOEXCEPT;

    Result Initialize(size_t uploadSize) NN_NOEXCEPT;

    using WebApiAccessorBase::SetDebugMode;

    using WebApiAccessorBase::SetUrl;
    using WebApiAccessorBase::SetHeaders;
    using WebApiAccessorBase::SetTimeoutSeconds;

    using WebApiAccessorBase::SetErrorHandler;

protected:
    /**
        @brief ストリームを開きます。
        @details
        ストリームを開き、 ImportJsonByRapidJson() で利用可能な状態にします。
    */
    Result Open() NN_NOEXCEPT;

    /**
        @brief ストリームを閉じます。
        @details
            ImportJsonByRapidJson() で利用中は閉じないでください。
     */
    void Close() NN_NOEXCEPT;

    /**
        @brief ストリーミング中にエラーが生じた場合、そのエラー Result が格納されます。
     */
    Result GetResult() const NN_NOEXCEPT;

    size_t Send(const void* buffer, size_t bufferSize) NN_NOEXCEPT;
    Result WaitForSendComplete() NN_NOEXCEPT;

    size_t m_UploadSize = 0;
};



class FsExporterUploader
    : public UploaderBase
{
public:
    FsExporterUploader(CURL* curlHandle, const nn::util::Cancelable* pCancelable = nullptr) NN_NOEXCEPT;
    Result Upload(fs::ISaveDataChunkExporter* exporter, void* buffer, size_t bufferSize) NN_NOEXCEPT;
};


}}}} // namespace nn::olsc::srv::transfer
