﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/http/json/http_JsonPath.h>
#include <nn/http/stream/http_CurlInputStream.h>
#include <nn/nn_Result.h>
#include <nn/olsc/srv/adaptor/olsc_AdaptorBase.h>
#include "../adaptor/olsc_OutputStream.h"
#include <nn/olsc/srv/olsc_InternalTypes.h>
#include <nn/fs/fs_SaveDataTransferForCloudBackUp.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace olsc { namespace srv { namespace transfer {

//TODO : Initial Data の取得は CurlInputStream を使わない方が効率的なので最適化検討時に修正。
class MemoryDownloader
    : public http::stream::CurlInputStreamBase
{
public:
    MemoryDownloader(CURL* curlHandle, const nn::util::Cancelable* pCancelable = nullptr) NN_NOEXCEPT;
    Result Download(size_t* pDownloadSize, void* buffer, size_t bufferSize) NN_NOEXCEPT;
};

class FsImporterDownloader
    : public http::stream::CurlInputStreamBase
{
public:
    FsImporterDownloader(CURL* curlHandle, const nn::util::Cancelable* pCancelable = nullptr) NN_NOEXCEPT;

    void SetInputBuffer(void* buffer, size_t bufferSize) NN_NOEXCEPT;

    Result Download(fs::ISaveDataChunkImporter* importer) NN_NOEXCEPT;

private:
    char* m_Buffer = nullptr;
    size_t m_BufferSize = 0;
    size_t m_BufferedBytes = 0;

    bool FillBuffer() NN_NOEXCEPT;
};


}}}} // namespace nn::olsc::srv::transfer
