﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <nn/olsc/srv/olsc_TransferTaskFactory.h>

namespace nn { namespace olsc { namespace srv {

namespace {
    TransferTaskBase* CreateTransferTask(void* storage, TransferTaskKind kind, TransferTaskBase::TransferTaskExecutionResource& resource) NN_NOEXCEPT
    {
        if (kind == TransferTaskKind::Download)
        {
            return new (storage) DownloadTransferTask(resource);
        }
        else if (kind == TransferTaskKind::Upload)
        {
            return new (storage) UploadTransferTask(resource);
        }
        NN_ABORT("Not come here.");
    }
}

// TODO : suspendedInfo を context に統合後削除
TransferTaskBase* TransferTaskFactory::Create(const TransferTaskDetailInfo& detailInfo, const SeriesInfo& lastSi, TransferTaskBase::TransferTaskExecutionResource& executionResource, TransferTaskSuspendedInfo&& suspendedInfo) NN_NOEXCEPT
{
    std::lock_guard<decltype(m_Lock)> lock(m_Lock);
    NN_SDK_REQUIRES(!m_Created);

    auto p = CreateTransferTask(&m_Storage, detailInfo.config.kind, executionResource);

    auto context = m_Ttdm.GetTransferTaskContext(detailInfo.id);
    if (context && suspendedInfo.IsValid() && (suspendedInfo.id == detailInfo.id))
    {
        p->Resume(detailInfo, *context, lastSi, std::move(suspendedInfo));
    }
    else
    {
        p->Initialize(detailInfo, lastSi);
    }
    m_Created = true;
    return p;
}

void TransferTaskFactory::Destroy(TransferTaskBase* task) NN_NOEXCEPT
{
    std::lock_guard<decltype(m_Lock)> lock(m_Lock);
    NN_SDK_REQUIRES(m_Created);
    m_Created = false;
    task->~TransferTaskBase();
}


}}} //namespace nn::olsc::srv

