﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/olsc/srv/olsc_AutoUploadSettingManager.h>
#include <nn/olsc/srv/olsc_InternalTypes.h>
#include <nn/util/util_LockGuard.h>

namespace nn { namespace olsc { namespace srv {

bool AutoUploadSettingManager::SetGlobalSetting(const account::Uid& uid, bool isEnabled) NN_NOEXCEPT
{
    auto writeMount = m_DatabaseManager.AcquireWriteMount(uid);
    auto db = m_DatabaseManager.Acquire(uid);
    NN_UTIL_LOCK_GUARD(db.Get());

    auto previous = db->GetGlobalSetting();
    if (previous == isEnabled)
    {
        return previous;
    }

    db->SetGlobalSetting(isEnabled);
    NN_ABORT_UNLESS_RESULT_SUCCESS(writeMount.Commit());

    return previous;
}

bool AutoUploadSettingManager::GetGlobalSetting(const account::Uid& uid) const NN_NOEXCEPT
{
    return m_DatabaseManager.Acquire(uid)->GetGlobalSetting();
}

void AutoUploadSettingManager::SetApplicationSetting(const account::Uid& uid, ApplicationId appId, database::AutoUploadSettingDatabase::ApplicationAutoUploadSetting setting) NN_NOEXCEPT
{
    auto writeMount = m_DatabaseManager.AcquireWriteMount(uid);
    m_DatabaseManager.Acquire(uid)->SetApplicationAutoUploadSetting(appId, setting);
    NN_ABORT_UNLESS_RESULT_SUCCESS(writeMount.Commit());
}

database::AutoUploadSettingDatabase::ApplicationAutoUploadSetting AutoUploadSettingManager::GetApplicationSetting(const account::Uid& uid, ApplicationId appId) const NN_NOEXCEPT
{
    return m_DatabaseManager.Acquire(uid)->GetApplicationAutoUploadSetting(appId);
}

void AutoUploadSettingManager::CleanupApplicationSetting(const account::Uid& uid) NN_NOEXCEPT
{
    auto writeMount = m_DatabaseManager.AcquireWriteMount(uid);
    m_DatabaseManager.Acquire(uid)->Cleanup();
    NN_ABORT_UNLESS_RESULT_SUCCESS(writeMount.Commit());
}

}}} //namespace nn::olsc::srv

