﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "olsc_MixedInfoAdaptor.h"
#include <nn/util/util_StringUtil.h>

namespace nn { namespace olsc { namespace srv { namespace adaptor {

bool MixedInfoAdaptor::UpdateImpl(const JsonPathType& jsonPath, bool value) NN_NOEXCEPT
{
    if(m_pAdaptorBase)
    {
        m_pAdaptorBase->Update(jsonPath, value);
    }
    return true;
}

bool MixedInfoAdaptor::UpdateImpl(const JsonPathType& jsonPath, int64_t value) NN_NOEXCEPT
{
    if(m_pAdaptorBase)
    {
        m_pAdaptorBase->Update(jsonPath, value);
    }
    return true;
}

bool MixedInfoAdaptor::UpdateImpl(const JsonPathType& jsonPath, uint64_t value) NN_NOEXCEPT
{
    if(m_pAdaptorBase)
    {
        m_pAdaptorBase->Update(jsonPath, value);
    }
    return true;
}

bool MixedInfoAdaptor::UpdateImpl(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT
{
    if(m_pAdaptorBase)
    {
        m_pAdaptorBase->Update(jsonPath, value, valueLength);
    }
    return true;
}

bool MixedInfoAdaptor::NotifyObjectBeginImpl(const JsonPathType& jsonPath) NN_NOEXCEPT
{
    // SaveDataArchiveInfo 解釈中に Begin が来た
    if( (m_pAdaptorBase == &m_SaveDataArchiveInfoAdaptor)
        && IsComponentFileInfoPath(jsonPath))
    {
        m_pAdaptorBase = &m_ComponentFileInfoAdaptor;
        m_pAdaptorBase->NotifyObjectBegin(jsonPath);
        return true;
    }

    // 解釈開始前に Begin が来た
    if(!m_pAdaptorBase && IsSaveDataArchiveInfoPath(jsonPath))
    {
        m_pAdaptorBase = &m_SaveDataArchiveInfoAdaptor;
        m_pAdaptorBase->NotifyObjectBegin(jsonPath);
        return true;
    }

    m_pAdaptorBase = nullptr;
    return true;
}

bool MixedInfoAdaptor::NotifyObjectEndImpl(const JsonPathType& jsonPath) NN_NOEXCEPT
{
    if(!m_pAdaptorBase)
    {
        return true;
    }

    m_pAdaptorBase->NotifyObjectEnd(jsonPath);

    // ComponentFileInfo 解釈中に ComponentFileInfo の End が来た
    if( (m_pAdaptorBase == &m_ComponentFileInfoAdaptor)
        && IsComponentFileInfoPath(jsonPath))
    {
        m_pAdaptorBase = &m_SaveDataArchiveInfoAdaptor;
        return true;
    }
    // SaveDataArchiveInfo 解釈中に SaveDataArchiveInfo の End が来た
    if( (m_pAdaptorBase == &m_SaveDataArchiveInfoAdaptor)
        && IsSaveDataArchiveInfoPath(jsonPath))
    {
        m_pAdaptorBase = nullptr;
        return true;
    }

    return true;
}

Result MixedInfoAdaptor::GetResult() const NN_NOEXCEPT
{
    NN_RESULT_DO(m_SaveDataArchiveInfoAdaptor.GetResult());
    NN_RESULT_DO(m_ComponentFileInfoAdaptor.GetResult());
    NN_RESULT_SUCCESS;
}

bool MixedInfoAdaptor::IsSaveDataArchiveInfoPath(const JsonPathType& jsonPath) const NN_NOEXCEPT
{
    static const char* SaveDataArchiveString = "$.save_data_archive";
    static const int SaveDataArchiveStringLength = static_cast<int>(std::strlen(SaveDataArchiveString));

    size_t fullPathLength = 0;
    const char* FullPath = jsonPath.ToString(&fullPathLength);
    if(nn::util::Strncmp(FullPath, SaveDataArchiveString, SaveDataArchiveStringLength + 1) == 0) // NULL 終端まで確認
    {
        return true;
    }
    return false;
}
bool MixedInfoAdaptor::IsComponentFileInfoPath(const JsonPathType& jsonPath) const NN_NOEXCEPT
{
    // index の値は m_ComponentFileInfoAdaptor で確認する
    static const char* ComponentFileString  = "$.save_data_archive.component_files";
    static const int ComponentFileStringLength = static_cast<int>(std::strlen(ComponentFileString));

    size_t fullPathLength = 0;
    const char* FullPath = jsonPath.ToString(&fullPathLength);

    if(nn::util::Strncmp(FullPath, ComponentFileString, ComponentFileStringLength) == 0)
    {
        return true;
    }
    return false;
}
}}}} //namespace nn::olsc::srv
