﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "detail/olsc_Initialization.h"

#include <nn/olsc/detail/olsc_Log.h>
#include <nn/olsc/olsc_Stopper.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/sfdl/olsc_IOlscService.sfdl.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>

namespace nn { namespace olsc {

Stopper::Stopper() NN_NOEXCEPT : m_Stopper(nullptr)
{}

Stopper::Stopper(srv::IStopperObject* stopper) NN_NOEXCEPT : m_Stopper(stopper)
{
    NN_SDK_REQUIRES_NOT_NULL(stopper);
}

Stopper::~Stopper() NN_NOEXCEPT
{
    if (m_Stopper)
    {
        sf::ReleaseSharedObject(m_Stopper);
    }
}

Stopper::Stopper(Stopper&& rhs) NN_NOEXCEPT
{
    m_Stopper = rhs.m_Stopper;
    rhs.m_Stopper = nullptr;
}

Stopper& Stopper::operator=(Stopper&& rhs) NN_NOEXCEPT
{
    Stopper s(std::move(rhs));
    swap(s, *this);
    return *this;
}

void swap(Stopper& lhs, Stopper& rhs) NN_NOEXCEPT
{
    std::swap(lhs.m_Stopper, rhs.m_Stopper);
}

}} // namespace nn::olsc

