﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/olsc/detail/olsc_Log.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/olsc_AsyncRequest.h>
#include <nn/olsc/sfdl/olsc_IOlscService.sfdl.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>

namespace nn { namespace olsc {

namespace {
}

AsyncRequest::AsyncRequest() NN_NOEXCEPT
    : m_AsyncResult(nullptr)
{}

AsyncRequest::AsyncRequest(srv::IAsyncResult* asyncResult) NN_NOEXCEPT
    : m_AsyncResult(asyncResult)
{}

AsyncRequest::~AsyncRequest() NN_NOEXCEPT
{
    if (m_AsyncResult)
    {
        sf::ReleaseSharedObject(m_AsyncResult);
    }
}

AsyncRequest::AsyncRequest(AsyncRequest&& rhs) NN_NOEXCEPT
{
    m_AsyncResult = rhs.m_AsyncResult;
    rhs.m_AsyncResult = nullptr;
}

AsyncRequest& AsyncRequest::operator=(AsyncRequest&& rhs) NN_NOEXCEPT
{
    AsyncRequest t(std::move(rhs));
    swap(*this, t);
    return *this;
}

void swap(AsyncRequest& lhs, AsyncRequest& rhs) NN_NOEXCEPT
{
    std::swap(lhs.m_AsyncResult, rhs.m_AsyncResult);
}

void AsyncRequest::Cancel() NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(m_AsyncResult);
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_AsyncResult->Cancel());
}

void AsyncRequest::GetEvent(os::SystemEvent* out) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(m_AsyncResult);
    NN_SDK_REQUIRES_NOT_NULL(out);

    sf::NativeHandle nativeHandle;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_AsyncResult->GetSystemEvent(&nativeHandle));
    out->AttachReadableHandle(nativeHandle.GetOsHandle(), nativeHandle.IsManaged(), os::EventClearMode_ManualClear);
    nativeHandle.Detach();
}

Result AsyncRequest::GetResult() NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(m_AsyncResult);
    bool available;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_AsyncResult->IsAvailable(&available));
    NN_SDK_ASSERT(available);

    return m_AsyncResult->GetResult();
}


}} // namespace nn::olsc

