﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <nn/sf/sf_Buffers.h>

#include <nn/oe/oe_ApplicationControlApis.h>
#include <nn/settings/settings_Language.h>

#include <nn/am/am_Shim.h>
#include <nn/arp/arp_Result.h>

namespace nn { namespace oe {

//-----------------------------------------------------------------------------

namespace {

void WarnUnregisteredApplication(Result result)
{
    if (result <= arp::ResultNotRegistered())
    {
        NN_SDK_LOG("[oe] Application control property not found. You must execute nsp or nspd to use application control property.\n");
    }
}

}   // namespace anonymous

//-----------------------------------------------------------------------------
// 本体設定に基づいてアプリケーションの対応言語を取得
//
settings::LanguageCode GetDesiredLanguage() NN_NOEXCEPT
{
    settings::LanguageCode language;
    auto result = am::GetApplicationFunctions()->GetDesiredLanguage( &language );
    WarnUnregisteredApplication( result );
    NN_ABORT_UNLESS_RESULT_SUCCESS( result );

    return language;
}


//-----------------------------------------------------------------------------
// アプリケーションのバージョン表記を取得
//
void GetDisplayVersion(DisplayVersion* outValue) NN_NOEXCEPT
{
    auto result = am::GetApplicationFunctions()->GetDisplayVersion( outValue );
    WarnUnregisteredApplication( result );
    NN_ABORT_UNLESS_RESULT_SUCCESS( result );
}

}}  // namespace nn::oe

