﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ntc/detail/shim/ntc_IpcSession.h>
#include <nn/ntc/service/ntc_ServiceName.h>

#include <nn/nn_SdkAssert.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/util/util_LockGuard.h>


namespace nn { namespace ntc { namespace detail { namespace shim {

namespace {
    nn::os::SdkMutex g_Lock;
    bool g_IsInitialized = false;

    // IStaticService から払い出されるInterfaceもあるので、同時に3つまで利用可とする(IStaticServiceと合わせて4)
    nn::sf::SimpleAllInOneHipcClientManager<4> g_Manager = NN_SF_SIMPLE_ALL_IN_ONE_HIPC_CLIENT_MANAGER_INITIALIZER;
    nn::sf::ShimLibraryObjectHolder<service::IStaticService> g_Holder = NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER;
}

nn::Result GetStaticServiceSharedPointer(
    nn::sf::SharedPointer<service::IStaticService>* pStaticService) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pStaticService);

    NN_UTIL_LOCK_GUARD(g_Lock);

    if(g_IsInitialized)
    {
        *pStaticService = g_Holder.GetObject();
        NN_RESULT_SUCCESS;
    }

    NN_RESULT_DO(g_Manager.InitializeShimLibraryHolder(&g_Holder, nn::ntc::service::ServiceName));
    *pStaticService = g_Holder.GetObject();
    g_IsInitialized = true;
    NN_RESULT_SUCCESS;
}

}}}} // nn::ntc::detail::shim
