﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/result/result_HandlingUtility.h>
#include <nn/ns/ns_Result.h>
#include "ns_ThreadAllocator.h"

namespace nn { namespace ns { namespace srv {

    ThreadAllocator::ThreadAllocator(os::ThreadType threadList[], int count, int priority, char* stackHeap, size_t stackHeapSize, size_t stackSize) NN_NOEXCEPT :
    m_ThreadList(threadList), m_ThreadPriority(priority), m_StackHeap(stackHeap), m_StackHeapSize(stackHeapSize), m_StackSize(stackSize), m_Bitmap(), m_BitArray(&m_Bitmap, sizeof(m_Bitmap), count)
    {
        NN_UNUSED(m_StackHeapSize);
        NN_SDK_ASSERT(count <= static_cast<int>(stackHeapSize / stackSize));
        NN_SDK_ASSERT(count <= NN_BITSIZEOF(decltype(m_Bitmap)));
    }

    Result ThreadAllocator::Allocate(ThreadInfo* outValue) NN_NOEXCEPT
    {
        std::lock_guard<os::Mutex> guard(m_Mutex);

        for (int i = 0; i < m_BitArray.size(); i++)
        {
            if (!m_BitArray[i])
            {
                ThreadInfo info = {
                    &m_ThreadList[i],
                    m_ThreadPriority,
                    &m_StackHeap[i * m_StackSize],
                    m_StackSize
                };
                *outValue = info;
                m_BitArray[i] = true;
                NN_RESULT_SUCCESS;
            }
        }

        NN_RESULT_THROW(ResultOutOfMaxRunningTask());
    }

    void ThreadAllocator::Free(const ThreadInfo& info) NN_NOEXCEPT
    {
        std::lock_guard<os::Mutex> guard(m_Mutex);

        for (int i = 0; i < m_BitArray.size(); i++)
        {
            if (info.thread == &m_ThreadList[i])
            {
                m_BitArray[i] = false;
                return;
            }
        }

        NN_ABORT("must not come here");
    }
}}}
