﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace ns { namespace srv {
    class SystemSaveDataSignature
    {
    public:
        SystemSaveDataSignature(const char* signature, uint32_t version) NN_NOEXCEPT;

        Result IsValidOn(bool* outValue, const char* mountName) NN_NOEXCEPT;

        Result WriteTo(const char* mountName) NN_NOEXCEPT;

    private:

        struct Data
        {
            uint32_t version;
            NN_PADDING4;
            char signature[16];
        };

        Data m_Data;
    };
}}}
