﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/arp/arp_Api.h>
#include <nn/ns/ns_Result.h>
#include <nn/ns/srv/ns_Shell.h>
#include <nn/result/result_HandlingUtility.h>
#include "ns_ProgramIndexUtil.h"

namespace nn { namespace ns { namespace srv {
    bool IsRunningApplication(ncm::ApplicationId id) NN_NOEXCEPT
    {
        auto pid = GetRunningApplicationProcessId();

        arp::ApplicationLaunchProperty property;
        return pid && arp::GetApplicationLaunchProperty(&property, *pid).IsSuccess() && property.id == id;
    }

    Result GetCurrentApplicationLaunchProperty(arp::ApplicationLaunchProperty* outValue) NN_NOEXCEPT
    {
        auto pid = GetRunningApplicationProcessId();
        NN_RESULT_THROW_UNLESS(pid, ResultApplicationNotRunning());

        NN_RESULT_DO(arp::GetApplicationLaunchProperty(outValue, *pid));

        NN_RESULT_SUCCESS;
    }

    Result GetRunningApplicationProgramId(ncm::ProgramId* outValue, ncm::ApplicationId id) NN_NOEXCEPT
    {
        arp::ApplicationLaunchProperty property;
        NN_RESULT_DO(GetCurrentApplicationLaunchProperty(&property));
        NN_RESULT_THROW_UNLESS(id == property.id, ResultApplicationNotRunning());

        *outValue = GetProgramId(property.id, property.programIndex);

        NN_RESULT_SUCCESS;
    }
}}}
