﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/srv/ns_Shell.h>
#include <nn/ns/detail/ns_Log.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace ns { namespace srv {

    void StartLaunchControl() NN_NOEXCEPT{}

    Result LaunchProgram(os::ProcessId* pOut, const ncm::ProgramLocation& location, int32_t flags) NN_NOEXCEPT
    {
        NN_UNUSED(pOut);
        NN_UNUSED(location);
        NN_UNUSED(flags);

        NN_DETAIL_NS_TRACE("ns::srv::LaunchProgram(storageId %u, programId 0x%016llx, flags 0x%08x)\n", location.storageId, location.programId.value, flags);

        NN_RESULT_SUCCESS;
    }

    Result TerminateProcess(os::ProcessId id) NN_NOEXCEPT
    {
        NN_UNUSED(id);

        NN_DETAIL_NS_TRACE("ns::srv::TerminateProcess(processId 0x%016llx)\n", id.value);

        NN_RESULT_SUCCESS;
    }

    Result TerminateProgram(ncm::ProgramId id) NN_NOEXCEPT
    {
        NN_UNUSED(id);

        NN_DETAIL_NS_TRACE("ns::srv::TerminateProgram(programId 0x%016llx)\n", id.value);

        NN_RESULT_SUCCESS;
    }

    Result TerminateApplication() NN_NOEXCEPT
    {
        NN_DETAIL_NS_TRACE("ns::srv::TerminateApplication()\n");

        NN_RESULT_SUCCESS;
    }

    void RegisterShellEventObserver(ShellEventObserverHolder* holder) NN_NOEXCEPT
    {
        NN_UNUSED(holder);
    }

    void UnregisterShellEventObserver(ShellEventObserverHolder* holder) NN_NOEXCEPT
    {
        NN_UNUSED(holder);
    }

    util::optional<os::ProcessId> GetRunningApplicationProcessId() NN_NOEXCEPT
    {
        NN_DETAIL_NS_TRACE("ns::srv::GetRunningApplicationProcessId()\n");

        return util::nullopt;
    }

    void EnableApplicationCrashReport(bool isEnabled) NN_NOEXCEPT
    {
        NN_UNUSED(isEnabled);
    }

    bool IsApplicationCrashReportEnabled() NN_NOEXCEPT
    {
        return false;
    }

    void EnableApplicationAllThreadDumpOnCrash(bool isEnabled) NN_NOEXCEPT
    {
        NN_UNUSED(isEnabled);
    }

    void RegisterApplicationCrashReportPolicy(ns::CrashReport policy) NN_NOEXCEPT
    {
        NN_UNUSED(policy);
    }


}}}

