﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/err/err_ErrorContext.h>
#include <nn/nim/nim_LocalCommunicationSendApplicationTaskId.h>
#include <nn/nim/nim_LocalCommunicationSendApplicationTaskInfo.h>
#include <nn/ns/ns_ContentDeliveryProgress.h>

namespace nn { namespace ns { namespace srv {

    class SendApplicationTask
    {
    public:
        explicit SendApplicationTask(ncm::ApplicationId appId) NN_NOEXCEPT;

        bool IsValid() const NN_NOEXCEPT
        {
            return m_IsValid;
        }

        Result GetProgress(SendApplicationProgress* outValue) NN_NOEXCEPT;

        Result Destroy() NN_NOEXCEPT;
        Result GetErrorContext(err::ErrorContext* outValue) NN_NOEXCEPT;

    private:
        bool m_IsValid {};
        nim::LocalCommunicationSendApplicationTaskId m_Id {};
    };
}}}

