﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_Result.h>
#include <nn/ns/detail/ns_Log.h>
#include <nn/nim/nim_LocalCommunicationSendApplicationTaskInfo.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>
#include <nn/util/util_TypedStorage.h>
#include "ns_SendApplicationTask.h"

namespace nn { namespace ns { namespace srv {

    SendApplicationTask::SendApplicationTask(ncm::ApplicationId appId) NN_NOEXCEPT
    {
        m_IsValid = nim::ListApplicationLocalCommunicationSendApplicationTask(&m_Id, 1, appId) > 0;
    }

    Result SendApplicationTask::GetProgress(SendApplicationProgress* outValue) NN_NOEXCEPT
    {
        nim::LocalCommunicationSendApplicationTaskInfo info;
        NN_RESULT_DO(nim::GetLocalCommunicationSendApplicationTaskInfo(&info, m_Id));

        *outValue = { info.progress.sentSize , info.progress.totalSize };

        NN_RESULT_SUCCESS;
    }

    Result SendApplicationTask::Destroy() NN_NOEXCEPT
    {
        return nim::DestroyLocalCommunicationSendApplicationTask(m_Id);
    }

    Result SendApplicationTask::GetErrorContext(err::ErrorContext* outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(nim::GetLocalCommunicationSendApplicationTaskErrorContext(outValue, m_Id));
        NN_RESULT_SUCCESS;
    }
}}}
