﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/srv/ns_IntegratedContentManager.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/ncm/ncm_ContentType.h>
#include <nn/ns/ns_Result.h>
#include "ns_ForEachUtil.h"
#include "ns_ProgramIndexUtil.h"
#include "ns_RightsUtil.h"

namespace nn { namespace ns { namespace srv {

    Result GetRightsIdIncludingKeyIdList(
        int* outCount, es::RightsIdIncludingKeyId* outList, int listCount,
        const ncm::ContentMetaKey& key, const IntegratedContentManager* pIntegrated, int offset) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(listCount >= 1, ResultBufferNotEnough());

        // TORIAEZU: offset アクセスには対応しない
        if (offset > 0)
        {
            *outCount = 0;
            NN_RESULT_SUCCESS;
        }

        int count = 0;
        // TORIAEZU: 現状 ContentMeta に紐付くコンテンツは全て同じ RightsId という前提の元、最適化をしておく
        NN_RESULT_DO(ForEachContentInfo(pIntegrated, key, [&](bool* outIsEnd, const ncm::ContentInfo& info) NN_NOEXCEPT -> Result
        {
            *outIsEnd = false;
            if (!IsCandidateForExternalKeyContents(info.type))
            {
                NN_RESULT_SUCCESS;
            }
            ncm::StorageId storageId;
            NN_RESULT_DO(pIntegrated->GetContentMetaStorage(&storageId, key));
            fs::RightsId fsRightsId;
            NN_RESULT_DO(pIntegrated->GetContentRightsId(&fsRightsId, key, info.type, GetProgramIndex(info), storageId));
            auto esRightsId = es::RightsIdIncludingKeyId::Construct(fsRightsId);
            if (esRightsId.IsExternalKey())
            {
                outList[count++] = esRightsId;
                *outIsEnd = true;
            }
            NN_RESULT_SUCCESS;
        }));

        *outCount = count;
        NN_RESULT_SUCCESS;
    }


    Result GetRightsIdList(
        int* outCount, es::RightsId* outList, int listCount,
        const ncm::ContentMetaKey& key, const IntegratedContentManager* pIntegrated, int offset) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(listCount >= 1, ResultBufferNotEnough());

        // TORIAEZU: offset アクセスには対応しない
        if (offset > 0)
        {
            *outCount = 0;
            NN_RESULT_SUCCESS;
        }

        // TORIAEZU: 現状 ContentMeta に紐付くコンテンツは全て同じ RightsId という前提の元、最適化をしておく
        es::RightsIdIncludingKeyId rightsId;
        int count;
        NN_RESULT_DO(GetRightsIdIncludingKeyIdList(&count, &rightsId, 1, key, pIntegrated));
        if (count > 0)
        {
            outList[0] = rightsId.GetRightsId();
            *outCount = 1;
        }
        else
        {
            *outCount = 0;
        }
        NN_RESULT_SUCCESS;
    }

    Result GetRightsIdListLightly(
        int* outCount, es::RightsId* outList, int listCount,
        const ncm::ContentMetaKey& key, const IntegratedContentManager* pIntegrated, int offset) NN_NOEXCEPT
    {
        NN_UNUSED(pIntegrated);
        NN_RESULT_THROW_UNLESS(listCount >= 1, ResultBufferNotEnough());

        // TORIAEZU: offset アクセスには対応しない
        if (offset > 0)
        {
            *outCount = 0;
            NN_RESULT_SUCCESS;
        }

        // TORIAEZU: RightsId == ContentMetaId という関係を利用する
        outList[0] = static_cast<es::RightsId>(key.id);
        *outCount = 1;
        NN_RESULT_SUCCESS;
    }

    bool IsCandidateForExternalKeyContents(ncm::ContentType type) NN_NOEXCEPT
    {
        return type != ncm::ContentType::Meta;
    }
}}}
