﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/ns/detail/ns_Log.h>
#include <nn/ns/ns_Result.h>
#include <nn/ns/srv/ns_PushNotificationDisptcher.h>

namespace nn { namespace ns { namespace srv {


    Result PushNotificationDispatcher::Initialize(nn::Bit64, ApplicationInstallRequestList*, RequestServer*, VulnerabilityManager*, ApplicationVersionManager*) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

    Result PushNotificationDispatcher::Initialize(nn::Bit64, Config&, ApplicationInstallRequestList*, RequestServer*, VulnerabilityManager*, ApplicationVersionManager*, AsyncTaskManager::NotificationHandlerHolder*, int, AsyncTaskManager::Config&) NN_NOEXCEPT
    {
        NN_DETAIL_NS_TRACE("[PushNotificationDispatcher] Not implemented on windows.");
        NN_RESULT_SUCCESS;
    }

    PushNotificationDispatcher::Config PushNotificationDispatcher::MakeDefaultConfig() NN_NOEXCEPT
    {
        return {};
    }

    void PushNotificationDispatcher::Finalize() NN_NOEXCEPT
    {
    }

    void PushNotificationDispatcher::Start() NN_NOEXCEPT
    {
    }

    void PushNotificationDispatcher::Stop() NN_NOEXCEPT
    {
    }

    PushNotificationDispatcher::EventIndex PushNotificationDispatcher::WaitAnyEvents() NN_NOEXCEPT
    {
        return PushNotificationDispatcher::EventIndex::StopEvent;
    }

    void PushNotificationDispatcher::SetupNotifications() NN_NOEXCEPT
    {
    }

    void PushNotificationDispatcher::DispatchThreadFunc() NN_NOEXCEPT
    {
    }

    void PushNotificationDispatcher::Dispatch() NN_NOEXCEPT
    {
    }

    Result PushNotificationDispatcher::RequestDownloadTaskList(const nn::nim::ETag&, bool) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

    Result PushNotificationDispatcher::RequestVersionList(const nn::nim::ETag&) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

    Result PushNotificationDispatcher::IsNotificationSetupCompleted(sf::Out<bool> outValue) NN_NOEXCEPT
    {
        *outValue = false;
        NN_RESULT_SUCCESS;
    }

    Result PushNotificationDispatcher::GetLastNotificationInfoCount(sf::Out<int64_t> outValue) NN_NOEXCEPT
    {
        *outValue = 0;
        NN_RESULT_SUCCESS;
    }

    Result PushNotificationDispatcher::ListLastNotificationInfo(sf::Out<int> outCount, const sf::OutArray<ns::NotificationInfo>&) NN_NOEXCEPT
    {
        *outCount = 0;
        NN_RESULT_SUCCESS;
    }

}}}
