﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/npns/npns_Types.h>
#include "ns_NpnsUtil.h"

namespace nn { namespace ns { namespace srv {
    class NotificationTokenCreationTaskBase : public INpnsOnlineTask
    {
    public:
        NN_IMPLICIT NotificationTokenCreationTaskBase(bool needsProcess) NN_NOEXCEPT
            : INpnsOnlineTask(needsProcess)
        {
        }
        virtual Result Process(nn::os::SystemEvent* cancelEvent) NN_NOEXCEPT NN_OVERRIDE;

    protected:
        virtual Result RegisterImpl(const nn::npns::NotificationToken& token, nn::os::SystemEvent* cancelEvent) NN_NOEXCEPT = 0;
    };

    class NotificationTokenCreationTask : public NotificationTokenCreationTaskBase
    {
    public:
        NN_IMPLICIT NotificationTokenCreationTask(bool needsProcess) NN_NOEXCEPT
            : NotificationTokenCreationTaskBase(needsProcess)
        {
        }

    protected:
        virtual Result RegisterImpl(const nn::npns::NotificationToken& token, nn::os::SystemEvent* cancelEvent) NN_NOEXCEPT NN_OVERRIDE;
    };

    class DynamicRightsNotificationTokenCreationTask : public NotificationTokenCreationTaskBase
    {
    public:
        NN_IMPLICIT DynamicRightsNotificationTokenCreationTask(bool needsProcess) NN_NOEXCEPT
            : NotificationTokenCreationTaskBase(needsProcess)
        {
        }

    protected:
        virtual Result RegisterImpl(const nn::npns::NotificationToken& token, nn::os::SystemEvent* cancelEvent) NN_NOEXCEPT NN_OVERRIDE;
    };

}}}
