﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/detail/ns_Log.h>

#define NN_NS_TRACE_RESULT_IF_FAILED(r, ...)                            \
    do                                                                  \
    {                                                                   \
        const auto& ns_result_temporary = r;                            \
        if (ns_result_temporary.IsFailure())                            \
        {                                                               \
            NN_DETAIL_NS_TRACE(__VA_ARGS__);                            \
            NN_DETAIL_NS_TRACE("  ^^^^ Failed result: 0x%08x ^^^^\n", ns_result_temporary.GetInnerValueForDebug()); \
        }                                                               \
    } while (NN_STATIC_CONDITION(0))
