﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fs/fs_SaveDataTypes.h>

namespace nn { namespace ns { namespace srv {
    static const int MaxContentMetaCountPerApplication = 2048;

    static const Bit64 ApplicationRecordSaveDataId       = 0x8000000000000040ull;
    static const Bit64 ApplicationControlCacheSaveDataId = 0x8000000000000041ull;
    static const Bit64 ApplicationManagerSaveDataId      = 0x8000000000000043ull;
    static const Bit64 SystemUpdateSaveDataId            = 0x8000000000000044ull;
    static const Bit64 VersionListSaveDataId             = 0x8000000000000045ull;
    static const Bit64 ExFatDriverSaveDataId             = 0x8000000000000047ull;
    static const Bit64 SystemSeedSaveDataId              = 0x8000000000000048ull;
    static const Bit64 SafeSystemVersionSaveDataId       = 0x8000000000000049ull;

    static const char ApplicationDataStoreMountName[]    = "ns_appman";
    static const char NsaCacheMountName[]                = "nsaccache";
    static const char VersionListMountName[]             = "vmdb";
    static const char SystemUpdateDataStoreMountName[]   = "ns_sysup";
    static const char LogoMountName[]                    = "ns_logo";
    static const char SystemUpdateMetaMountName[]        = "ns_sysupmeta";
    static const char ExFatDriverMountName[]             = "ns_exfat";
    static const char SystemSeedMountName[]              = "ns_systemseed";
    static const char SafeSystemVersionMountName[]       = "ns_ssversion";

    static const int64_t   ApplicationRecordSaveDataSize                = 0x80C8000; // 128MB + 16 KB * (49 + 1) ブロック
    static const int64_t   ApplicationRecordSaveDataJournalSize         = 0x60000; // 352KB + 32 KB
    static const int       ApplicationRecordSaveDataFlag                = 0; // TORIAEZU: fs チームから指示があったら修正する

    static const int64_t    ApplicationControlCacheSaveDataSize         = 0x10028000; // 256 MB + 32 KB + 128 KB
    static const int64_t    ApplicationControlCacheSaveDataJournalSize  = 0x48000; // 256 KB + 32 KB
    static const uint32_t   ApplicationControlCacheSaveDataFlags        = fs::SaveDataFlags_KeepAfterResettingSystemSaveDataWithoutUserSaveData;

    static const int64_t    ApplicationManagerSaveDataSize              = 0xC000; // 16 KB + 32 KB
    static const int64_t    ApplicationManagerSaveDataJournalSize       = 0xC000; // 16 KB + 32 KB
    static const uint32_t   ApplicationManagerSaveDataFlags             = 0;

    static const int64_t    SystemUpdateSaveDataSize                    = 0x10C000; // 16 KB + 32 KB + 1MB
    static const int64_t    SystemUpdateSaveDataJournalSize             = 0x10C000; // 16 KB + 32 KB + 1MB
    static const int        SystemUpdateSaveDataFlags                   = 0;

    static const int64_t    ExFatDriverManagerSaveDataSize              = 0xC000; // 16 KB + 32 KB
    static const int64_t    ExFatDriverManagerSaveDataJournalSize       = 0xC000; // 16 KB + 32 KB
    static const int        ExFatDriverManagerSaveDataFlags             = fs::SaveDataFlags_KeepAfterResettingSystemSaveData | nn::fs::SaveDataFlags_KeepAfterRefurbishment;

    static const uint32_t   VersionListSaveDataFlags                    = fs::SaveDataFlags_KeepAfterResettingSystemSaveDataWithoutUserSaveData;

    static const int64_t    SystemSeedSaveDataSize                      = 0xC000; // 16 KB + 32 KB
    static const int64_t    SystemSeedSaveDataJournalSize               = 0xC000; // 16 KB + 32 KB
    static const uint32_t   SystemSeedSaveDataFlags                     = fs::SaveDataFlags_KeepAfterResettingSystemSaveData;

    static const int64_t    SafeSystemVersionSaveDataSize               = 0xC000; // 16KB + 32 KB
    static const int64_t    SafeSystemVersionSaveDataJournalSize        = 0xC000; // 16KB + 32 KB
    static const uint32_t   SafeSystemVersionSaveDataFlags              = fs::SaveDataFlags_KeepAfterResettingSystemSaveData | fs::SaveDataFlags_KeepAfterRefurbishment;
}}}
