﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include "ns_AsyncThreadAllocator.h"

namespace nn { namespace ns { namespace srv {
    namespace {
        static const int ThreadCount = 1;
        static const size_t StackSize = 16 * 1024;

        os::ThreadType g_ThreadList[ThreadCount];
        NN_OS_ALIGNAS_THREAD_STACK char g_Stack[StackSize * ThreadCount];

        ThreadAllocator g_ThreadAllocator(g_ThreadList, ThreadCount, os::InvalidThreadPriority, g_Stack, sizeof(g_Stack), StackSize);
    }


ThreadAllocator* GetAsyncThreadAllocator() NN_NOEXCEPT
{
    return &g_ThreadAllocator;
}

}}} // namespace nn::ns::srv
