﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>
#include <nn/ns/ns_DownloadTaskSystemApi.h>
#include <nn/ns/srv/ns_RequestServer.h>

#include "ns_AsyncImpl.h"

namespace nn { namespace ns { namespace srv {
    class DownloadTaskListManager;

    class AsyncEnsureDownloadTaskImpl : public AsyncResultBase, private ErrorContextHolder
    {
    public:
        AsyncEnsureDownloadTaskImpl(DownloadTaskListManager* dtlManager, RequestServer::ManagedStop&& stopper) NN_NOEXCEPT :
            m_DtlManager(dtlManager), m_Stopper(std::move(stopper)) {}

        Result Initialize() NN_NOEXCEPT
        {
            NN_RESULT_TRY(nim::RequestDownloadTaskList(&m_AsyncDownloadTaskData, nim::ETag::MakeEmpty()))
                NN_RESULT_CATCH_CONVERT(nim::ResultOutOfMaxTask, ResultOutOfMaxRunningTask())
                NN_RESULT_CATCH_CONVERT(nim::ResultOutOfMaxRunningTask, ResultOutOfMaxRunningTask())
            NN_RESULT_END_TRY
            NN_RESULT_SUCCESS;
        }

        os::SystemEvent& GetEvent() NN_NOEXCEPT
        {
            return m_AsyncDownloadTaskData.GetEvent();
        }

        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            *outValue = ErrorContextHolder::GetErrorContextImpl();
            NN_RESULT_SUCCESS;
        }

    private:
        virtual Result GetImpl() NN_NOEXCEPT NN_OVERRIDE;
        virtual void CancelImpl() NN_NOEXCEPT NN_OVERRIDE
        {
            m_AsyncDownloadTaskData.Cancel();
        }

        DownloadTaskListManager* m_DtlManager;;
        RequestServer::ManagedStop m_Stopper;
        nim::AsyncData m_AsyncDownloadTaskData;
    };

    class AsyncDownloadTaskListDataImpl : public AsyncValueBase, private ErrorContextHolder
    {
    public:
        explicit AsyncDownloadTaskListDataImpl(RequestServer::ManagedStop&& stopper) NN_NOEXCEPT : m_Stopper(std::move(stopper)) {}

        Result Initialize() NN_NOEXCEPT
        {
            return nim::RequestDownloadTaskList(&m_AsyncDownloadTaskData, nim::ETag::MakeEmpty());
        }
        os::SystemEvent& GetEvent() NN_NOEXCEPT
        {
            return m_AsyncDownloadTaskData.GetEvent();
        }

        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            *outValue = ErrorContextHolder::GetErrorContextImpl();
            NN_RESULT_SUCCESS;
        }

    private:
        virtual size_t GetSizeImpl() NN_NOEXCEPT NN_OVERRIDE
        {
            return static_cast<size_t>(m_AsyncDownloadTaskData.GetSize());
        }
        virtual Result GetImpl(const nn::sf::OutBuffer& buffer) NN_NOEXCEPT NN_OVERRIDE;
        virtual void CancelImpl() NN_NOEXCEPT NN_OVERRIDE
        {
            m_AsyncDownloadTaskData.Cancel();
        }

        RequestServer::ManagedStop m_Stopper;
        nim::AsyncData m_AsyncDownloadTaskData;
    };
}}}

