﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>
#include "ns_AsyncImpl.h"

namespace nn { namespace ns { namespace srv {

    class ApplicationControlDataManager;

    class AsyncDownloadApplicationControlDataImpl : public AsyncResultBase, private ErrorContextHolder
    {
    public:
        AsyncDownloadApplicationControlDataImpl(ApplicationControlDataManager* manager, RequestServer::ManagedStop&& stopper) NN_NOEXCEPT : m_Manager(manager), m_Stopper(std::move(stopper)) {}

        Result Initialize(ncm::ApplicationId id) NN_NOEXCEPT;

        os::SystemEvent& GetEvent() NN_NOEXCEPT;

        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            *outValue = ErrorContextHolder::GetErrorContextImpl();
            NN_RESULT_SUCCESS;
        }

    private:
        virtual void CancelImpl() NN_NOEXCEPT NN_OVERRIDE
        {
            m_AsyncApplicationControlInfo.Cancel();
        }
        virtual Result GetImpl() NN_NOEXCEPT NN_OVERRIDE;

        ApplicationControlDataManager* m_Manager;
        ncm::ApplicationId m_Id;
        nim::AsyncApplicationControlInfo m_AsyncApplicationControlInfo;
        RequestServer::ManagedStop m_Stopper;
    };
}}}

