﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/account/account_ApiForSystemServices.h>
#include <nn/ns/detail/ns_Log.h>
#include <nn/result/result_HandlingUtility.h>
#include "ns_AccountUtil.h"

namespace nn { namespace ns { namespace srv {
    Result GetNintendoAccountId(account::NintendoAccountId* outValue, const account::Uid& uid) NN_NOEXCEPT
    {
        account::NetworkServiceAccountManager accountManager;
        NN_ABORT_UNLESS_RESULT_SUCCESS(account::GetNetworkServiceAccountManager(&accountManager, uid));
        NN_RESULT_DO(accountManager.GetNintendoAccountId(outValue));
        NN_RESULT_SUCCESS;
    }

    bool IsAvailableNaIdToken(const account::Uid& uid) NN_NOEXCEPT
    {
        if (uid == account::InvalidUid)
        {
            return false;
        }
        else
        {
            account::NetworkServiceAccountManager accountManager;
            NN_ABORT_UNLESS_RESULT_SUCCESS(account::GetNetworkServiceAccountManager(&accountManager, uid));
            auto result = accountManager.CheckNetworkServiceAccountAvailability();
            if (result.IsSuccess())
            {
                return true;
            }
            else
            {
                NN_DETAIL_NS_TRACE("Account is not available NA ID Token. (result=%08x)\n", result.GetInnerValueForDebug());
                return false;
            }
        }
    }
}}}
