﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/account_Api.h>
#include <nn/account/account_ApiForAdministrators.h>
#include <nn/ns/ns_Result.h>
#include <nn/ns/srv/ns_AccountProxyManager.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace ns { namespace srv {

    Result AccountProxyManager::CreateUserAccount(account::Nickname name, sf::InBuffer image) NN_NOEXCEPT
    {
        account::Uid uid;
        NN_RESULT_DO(account::BeginUserRegistration(&uid));

        account::ProfileEditor editor;
        NN_RESULT_TRY(account::GetProfileEditor(&editor, uid))
            NN_RESULT_CATCH_ALL
            {
                NN_RESULT_DO(account::CancelUserRegistration(uid));
                NN_RESULT_RETHROW;
            }
        NN_RESULT_END_TRY

        editor.SetNickname(name);
        NN_RESULT_TRY(editor.FlushWithImage(image.GetPointerUnsafe(), image.GetSize()))
            NN_RESULT_CATCH_ALL
            {
                NN_RESULT_DO(account::CancelUserRegistration(uid));
                NN_RESULT_RETHROW;
            }
        NN_RESULT_END_TRY

        NN_RESULT_DO(account::CompleteUserRegistration(uid));

        NN_RESULT_SUCCESS;
    }
}}}
