﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nsd/detail/nsd_Shim.h>
#include <nn/nsd/nsd_ApiForMiddleware.h>
#include <nn/nsd/detail/nsd_FqdnResolver.h>
#include <nn/nsd/detail/nsd_Log.h>

#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace nsd {

    namespace
    {
        void DumpErrorLog(Result result, const char* caption, const Fqdn& inFqdn) NN_NOEXCEPT
        {
            NN_UNUSED(result);
            NN_UNUSED(caption);
            NN_UNUSED(inFqdn);

            NN_DETAIL_NSD_ERROR("%s failed. in(%.255s) (%08x, %03d-%04d)\n",
                caption,
                inFqdn.value,
                result.GetInnerValueForDebug(),
                result.GetModule(), result.GetDescription());
        }
    }

    Result Resolve(Fqdn *pOut, const Fqdn& fqdn) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOut);
        auto result = nn::nsd::detail::ipc::Resolve(pOut, fqdn);

        if(result.IsFailure())
        {
            DumpErrorLog(result, "nn::nsd::Resolve", fqdn);
        }

        return result;
    }

    Result ResolveEx(Fqdn *pOut, const Fqdn& fqdn) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOut);
        Result innerResult;
        auto result = nn::nsd::detail::ipc::ResolveEx(&innerResult, pOut, fqdn);

        if(result.IsFailure())
        {
            DumpErrorLog(result, "nn::nsd::ResolveEx", fqdn);
        }
        else if(innerResult.IsFailure())
        {
            // result自体は成功だが、内部の innerResult が失敗
            DumpErrorLog(innerResult, "nn::nsd::ResolveEx", fqdn);
        }

        return result;
    }

}} // nn::nsd
