﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nsd/detail/server/nsd_ManagerImpl.h>
#include <nn/nsd/detail/nsd_ServiceObjectHipc.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nsd/nsd_TypesPrivate.h>
#include <nn/nsd/nsd_ServiceName.h>
#include <nn/nsd/nsd_Result.h>

#include <nn/sf/sf_ShimLibraryUtility.h>

namespace nn { namespace nsd { namespace detail {

namespace {
    nn::sf::SimpleAllInOneHipcClientManager<1> g_Manager = NN_SF_SIMPLE_ALL_IN_ONE_HIPC_CLIENT_MANAGER_INITIALIZER;
    nn::sf::ShimLibraryObjectHolder<IManager> g_Holder = NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER;
}

//----------------------------------------------------------------
// HIPC によるサービスオブジェクトへの参照
nn::Result GetServiceObjectByHipc( nn::sf::SharedPointer<IManager>*pObject,  nn::nsd::ServiceType type ) NN_NOEXCEPT
{
    nn::sf::SharedPointer<IManager> ret;
    nn::Result result;

    switch( type )
    {
        case nn::nsd::ServiceType_User:
            NN_RESULT_DO(g_Manager.InitializeShimLibraryHolder(&g_Holder, nn::nsd::ServiceNameForUser));
            break;

        case nn::nsd::ServiceType_Admin:
            NN_RESULT_DO(g_Manager.InitializeShimLibraryHolder(&g_Holder, nn::nsd::ServiceNameForAdmin ));
            break;

        default:
            NN_RESULT_THROW( nn::nsd::ResultInvalidArgument() );
    }

    *pObject = g_Holder.GetObject();
    NN_RESULT_SUCCESS;
}

}}}  // nn::nsd::detail
