﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nsd/detail/server/nsd_ManagerImpl.h>
#include <nn/nsd/detail/nsd_ServiceObjectDfc.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nsd/nsd_ServiceName.h>
#include <nn/nsd/nsd_TypesPrivate.h>

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/impl/sf_StaticOneAllocator.h>

namespace nn { namespace nsd { namespace detail {

#if !defined( NN_BUILD_CONFIG_OS_WIN )
class ServiceObjectManager
{
public:
    explicit ServiceObjectManager( nn::nsd::ServiceType serviceType ) NN_NOEXCEPT
        : m_ServiceObject( serviceType )
    {}

    ~ServiceObjectManager() NN_NOEXCEPT
    {}

    nn::sf::UnmanagedServiceObject<IManager, server::ManagerImpl>& GetServiceObject() NN_NOEXCEPT
    {
        return m_ServiceObject;
    }

private:
    nn::sf::UnmanagedServiceObject<IManager, server::ManagerImpl> m_ServiceObject;
};
#endif

//----------------------------------------------------------------
// DFC によるサービスオブジェクトへの参照
nn::Result GetServiceObjectByDfc( nn::sf::SharedPointer<IManager>*pObject,  nn::nsd::ServiceType serviceType ) NN_NOEXCEPT
{
#if defined( NN_BUILD_CONFIG_OS_WIN )
    typedef nn::sf::ObjectFactory<nn::sf::impl::StaticOneAllocationPolicy> Factory;

    switch( serviceType )
    {
        case nn::nsd::ServiceType_User:
            *pObject = Factory::CreateSharedEmplaced<IManager, server::ManagerImpl>(nn::nsd::ServiceType_User);
            break;

        case nn::nsd::ServiceType_Admin:
            *pObject = Factory::CreateSharedEmplaced<IManager, server::ManagerImpl>(nn::nsd::ServiceType_Admin);
            break;

        default:
            *pObject = nullptr;
            NN_RESULT_THROW( nn::nsd::ResultInvalidArgument() );
    }
#else
    static ServiceObjectManager g_ServiceObjectManagerForUser( nn::nsd::ServiceType_User );
    static ServiceObjectManager g_ServiceObjectManagerForAdmin( nn::nsd::ServiceType_Admin );

    switch( serviceType )
    {
        case nn::nsd::ServiceType_User:
            *pObject = g_ServiceObjectManagerForUser.GetServiceObject().GetShared();
            break;

        case nn::nsd::ServiceType_Admin:
            *pObject = g_ServiceObjectManagerForAdmin.GetServiceObject().GetShared();
            break;

        default:
            *pObject = nullptr;
            NN_RESULT_THROW( nn::nsd::ResultInvalidArgument() );
    }
#endif

    NN_RESULT_SUCCESS;
}

}}}  // nn::nsd::detail
