﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nsd/detail/device/nsd_Device.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/util/util_StringUtil.h>

#include <nn/nn_SdkAssert.h>

//
// デバイス設定的なことを扱うものをここへ集める
//

namespace nn { namespace nsd { namespace detail { namespace device {

namespace
{
    // settings で指定されている、nsd 環境識別子 を表す名前/キー
    const char SettingsName[] = "nsd";
    const char SettingsKey[] = "environment_identifier";

    // 環境識別子
    EnvironmentIdentifier s_EnvironmentIdentifier;
    bool s_IsEnvironmentIdentifierDetermined = false; // 決定済み
}

    void LoadOwnDeviceId(DeviceId* pOut) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pOut);

        // TODO
        // 設定の書き込み時、読み込み時にしか叩かれないので少々重くても良い

        const DeviceId dummy = {{"0123456789"}}; // TORIAEZU
        *pOut = dummy;
    }

    //----------------------------------------------------------------
    // settings から環境識別子を取得する
    //
    // settings に SettingsName と SettingsKey で示すパラメータとして環境識別子が与えられている。
    // 与えられていないときは ABORT。
    // EnvironmentIdentifierOfProductDevice か EnvironmentIdentifierOfNotProductDevice
    // でない場合も ABORT する。
    //
    EnvironmentIdentifier& GetEnvironmentIdentifierFromSettings() NN_NOEXCEPT
    {
        if ( ! s_IsEnvironmentIdentifierDetermined )
        {
#if !defined(NN_BUILD_CONFIG_OS_WIN)
            size_t size = nn::settings::fwdbg::GetSettingsItemValueSize( SettingsName, SettingsKey );
            NN_ABORT_UNLESS_NOT_EQUAL( size, 0 );

            // settings から値の取得
            size = nn::settings::fwdbg::GetSettingsItemValue( s_EnvironmentIdentifier.value, s_EnvironmentIdentifier.Size, SettingsName, SettingsKey );
            NN_ABORT_UNLESS_LESS( size, static_cast<const size_t>(nn::nsd::EnvironmentIdentifier::Size) );
            NN_ABORT_UNLESS( s_EnvironmentIdentifier == EnvironmentIdentifierOfProductDevice ||
                             s_EnvironmentIdentifier == EnvironmentIdentifierOfNotProductDevice );
#else
            nn::util::Strlcpy( s_EnvironmentIdentifier.value, EnvironmentIdentifierOfNotProductDevice.value, static_cast<int>(EnvironmentIdentifier::Size) );
#endif
            s_IsEnvironmentIdentifierDetermined = true;
        }

        return s_EnvironmentIdentifier;
    }

}}}} // nn::nsd::detail::device
