﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.settings
{
    [CppRefPath(@"<nn/settings/settings_Language.h>")]
    [ExternalStruct(8, 1)]
    public struct LanguageCode {}
}

namespace nn.settings.system
{
    [CppRefPath(@"<nn/settings/system/settings_Region.h>")]
    [ExternalStruct(4, 4)]
    public struct RegionCode {}
}

namespace nn.ns
{
    [CppRefPath(@"<nn/ns/ns_SystemUpdateApi.h>")]
    [ExternalStruct(16, 8)]
    public struct SystemUpdateProgress{}

    [CppRefPath(@"<nn/ns/ns_SystemUpdateApi.h>")]
    [ExternalStruct(1, 1)]
    public struct BackgroundNetworkUpdateState{}

    [CppRefPath(@"<nn/ns/ns_SystemDeliveryInfo.h>")]
    [ExternalStruct(256,8)]
    [LargeData(true)]
    public struct SystemDeliveryInfo{}
}

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ContentMetaKey.h>")]
    [ExternalStruct(16, 8)]
    public struct ContentMetaKey {}
}

namespace nn.ns.detail
{
    [LargeData]
    public struct EulaDataPath
    {
        [FixedArray(256)]
        public char_t[] str;
    }

    public interface ISystemUpdateControl : IServiceObject
    {
        [MethodId(0)]
        Result HasDownloaded(Out<bool> outValue);

        [MethodId(1)]
        Result RequestCheckLatestUpdate(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync);

        [MethodId(2)]
        Result RequestDownloadLatestUpdate(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync);

        [MethodId(3)]
        Result GetDownloadProgress(Out<SystemUpdateProgress> outValue);

        [MethodId(4)]
        Result ApplyDownloadedUpdate();

        [MethodId(5)]
        Result RequestPrepareCardUpdate(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync);

        [MethodId(6)]
        Result GetPrepareCardUpdateProgress(Out<SystemUpdateProgress> outValue);

        [MethodId(7)]
        Result HasPreparedCardUpdate(Out<bool> outValue);

        [MethodId(8)]
        Result ApplyCardUpdate();

        [MethodId(9)]
        Result GetDownloadedEulaDataSize(Out<uint64_t> outValue, [BufferTransferMode(BufferTransferMode.MapAlias)] EulaDataPath path);

        [MethodId(10)]
        Result GetDownloadedEulaData(Out<uint64_t> outValue, OutBuffer buffer, [BufferTransferMode(BufferTransferMode.MapAlias)] EulaDataPath path);

        [MethodId(11)]
        Result SetupCardUpdate(NativeHandle transferMemoryHandle, uint64_t transferMemorySize);

        [MethodId(12)]
        Result GetPreparedCardUpdateEulaDataSize(Out<uint64_t> outValue, [BufferTransferMode(BufferTransferMode.MapAlias)] EulaDataPath path);

        [MethodId(13)]
        Result GetPreparedCardUpdateEulaData(Out<uint64_t> outValue, OutBuffer buffer, [BufferTransferMode(BufferTransferMode.MapAlias)] EulaDataPath path);

        [MethodId(14)]
        Result SetupCardUpdateViaSystemUpdater(NativeHandle transferMemoryHandle, uint64_t transferMemorySize);

        [MethodId(15)]
        Result HasReceived(Out<bool> outValue);

        [MethodId(16)]
        Result RequestReceiveSystemUpdate(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, uint32_t ipv4, uint16_t port, [BufferTransferMode(BufferTransferMode.MapAlias)] SystemDeliveryInfo info);

        [MethodId(17)]
        Result GetReceiveProgress(Out<SystemUpdateProgress> outValue);

        [MethodId(18)]
        Result ApplyReceivedUpdate();

        [MethodId(19)]
        Result GetReceivedEulaDataSize(Out<uint64_t> outValue, [BufferTransferMode(BufferTransferMode.MapAlias)] EulaDataPath path);

        [MethodId(20)]
        Result GetReceivedEulaData(Out<uint64_t> outValue, OutBuffer buffer, [BufferTransferMode(BufferTransferMode.MapAlias)] EulaDataPath path);

        [MethodId(21)]
        Result SetupToReceiveSystemUpdate();
    }

    public interface ISystemUpdateInterface : IServiceObject
    {
        [MethodId(0)]
        Result GetBackgroundNetworkUpdateState(Out<BackgroundNetworkUpdateState> outValue);

        [MethodId(1)]
        Result OpenSystemUpdateControl(Out<ISystemUpdateControl> outValue);

        [MethodId(2)]
        Result NotifyExFatDriverRequired();

        [MethodId(3)]
        Result ClearExFatDriverStatusForDebug();

        [MethodId(4)]
        Result RequestBackgroundNetworkUpdate();

        [MethodId(5)]
        Result NotifyBackgroundNetworkUpdate(nn.ncm.ContentMetaKey systemUpdateMetaKey);

        [MethodId(6)]
        Result NotifyExFatDriverDownloadedForDebug();

//        [MethodId(7)]
//        Result GetBackgroundNetworkUpdateIdleEvent(Out<NativeHandle> outValue);

//        [MethodId(8)]
//        Result SignalBackgroundNetworkUpdateIdleEventForDebug();

        [MethodId(9)]
        Result GetSystemUpdateNotificationEventForContentDelivery(Out<NativeHandle> outValue);

        [MethodId(10)]
        Result NotifySystemUpdateForContentDelivery();

        [MethodId(11)]
        Result PrepareShutdown();

//      [MethodId(12)]
//      Result GetNeedsSystemUpdateNotificationEventToEnableAutoUpdate(Out<NativeHandle> outValue);

//      [MethodId(13)]
//      Result NotifyNeedsSystemUpdateToEnableAutoUpdate();

//      [MethodId(14)]
//      Result GetSystemUpdateCheckedNotificationEvent(Out<NativeHandle> outValue);

//      [MethodId(15)]
//      Result NotifySystemUpdateChecked();

        [MethodId(16)]
        Result DestroySystemUpdateTask();

        [MethodId(17)]
        Result RequestSendSystemUpdate(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, uint32_t ipv4, uint16_t port, [BufferTransferMode(BufferTransferMode.MapAlias)] SystemDeliveryInfo info);

        [MethodId(18)]
        Result GetSendSystemUpdateProgress(Out<SystemUpdateProgress> outValue);
    }
}
