﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_SdCardApi.h>
#include <nn/ns/ns_SdCardSystemApi.h>
#include "ns_Initialize.h"

namespace nn { namespace ns {
    Result CleanupSdCard() NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->CleanupSdCard();
    }

    Result CheckSdCardMountStatus() NN_NOEXCEPT
    {
        return GetContentManagementInterface()->CheckSdCardMountStatus();
    }

    void GetSdCardMountStatusChangedEvent(os::SystemEvent* pOutEvent) NN_NOEXCEPT
    {
        sf::NativeHandle sfHandle;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->GetSdCardMountStatusChangedEvent(sf::Out<sf::NativeHandle>(&sfHandle)));

        pOutEvent->AttachReadableHandle(sfHandle.GetOsHandle(), sfHandle.IsManaged(), os::EventClearMode_ManualClear);
        sfHandle.Detach();
    }

    void GetSdCardRemovedEvent(os::SystemEvent* pOutEvent) NN_NOEXCEPT
    {
        sf::NativeHandle sfHandle;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->GetSdCardRemovedEvent(sf::Out<sf::NativeHandle>(&sfHandle)));

        pOutEvent->AttachReadableHandle(sfHandle.GetOsHandle(), sfHandle.IsManaged(), os::EventClearMode_ManualClear);
        sfHandle.Detach();
    }

    Result GetLastSdCardMountUnexpectedResult() NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->GetLastSdCardMountUnexpectedResult();
    }

    Result FormatSdCard() NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->FormatSdCard();
    }

    Result NeedsSystemUpdateToFormatSdCard(bool* outValue) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->NeedsSystemUpdateToFormatSdCard(outValue);
    }

    Result GetLastSdCardFormatUnexpectedResult() NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->GetLastSdCardFormatUnexpectedResult();
    }

    void InsertSdCard() NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->InsertSdCard());
    }

    void RemoveSdCard() NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->RemoveSdCard());
    }
}}

