﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_PseudoDeviceIdApi.h>
#include "ns_Initialize.h"

namespace nn { namespace ns {

//-----------------------------------------------------------------------------
// 疑似本体 ID 生成に必要な System Seed の取得
//
void GetSystemSeedForPseudoDeviceId(SystemSeedForPseudoDeviceId* pOutSeed) NN_NOEXCEPT
{
    auto result = ns::GetApplicationManagerInterface()->GetSystemSeedForPseudoDeviceId( pOutSeed );
    NN_ABORT_UNLESS_RESULT_SUCCESS( result );
}

//-----------------------------------------------------------------------------
// 疑似本体 ID 生成に必要な System Seed のリセット
//
Result ResetSystemSeedForPseudoDeviceId() NN_NOEXCEPT
{
    return ns::GetApplicationManagerInterface()->ResetSystemSeedForPseudoDeviceId();
}

}}  // namespace nn::ns
