﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ncm/ncm_Service.h>
#include <nn/ns/ns_InstallApi.h>
#include <nn/ns/ns_ApplicationEntitySystemApi.h>
#include <nn/ns/ns_ApplicationRecordSystemApi.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace ns {

    Result ApplicationInstallTask::Initialize(fs::FileHandle file, ncm::StorageId storage, void* buffer, size_t bufferSize, bool ignoreTicket) NN_NOEXCEPT
    {
        NN_RESULT_DO(ncm::SubmissionPackageInstallTask::Initialize(file, storage, buffer, bufferSize, ignoreTicket));

        NN_RESULT_SUCCESS;
    }

    Result ApplicationInstallTask::Commit() NN_NOEXCEPT
    {
        NN_RESULT_DO(ncm::SubmissionPackageInstallTask::Commit());
        NN_RESULT_DO(PostCommit());

        NN_RESULT_SUCCESS;
    }

    Result ApplicationInstallTask::PostCommit() NN_NOEXCEPT
    {
        int count;
        ncm::ApplicationContentMetaKey appKey;
        NN_RESULT_DO(ListApplicationContentMetaKey(&count, &appKey, 1, 0));
        if (count > 0)
        {
            int offset = 0;
            for (;;)
            {
                ncm::StorageContentMetaKey keyList[16];
                const int Count = sizeof(keyList) / sizeof(keyList[0]);
                int outCount;

                NN_RESULT_DO(ListContentMetaKey(&outCount, keyList, Count, offset));

                for (int i = 0; i < outCount; i++)
                {
                    NN_RESULT_DO(ns::PushApplicationRecord(appKey.applicationId, ApplicationEvent::LocalInstalled, keyList, outCount));
                }

                if (outCount < Count)
                {
                    break;
                }

                offset += outCount;
            }
        }
        NN_RESULT_DO(CleanupUnrecordedApplicationEntity(appKey.applicationId));

        NN_RESULT_SUCCESS;
    }
}}
