﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <type_traits>
#include <nn/sf/sf_ProxyObjectAllocator.h>
#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_ApplicationManagerInitializeApi.h>
#include <nn/ns/ns_ApplicationManagerSystemApi.h>
#include <nn/ns/ns_EcAppletApi.h>
#include <nn/ns/ns_WebAppletApi.h>
#include <nn/ns/ns_VulnerabilityApi.h>
#include <nn/ns/ns_RepairToolApi.h>
#include <nn/ns/detail/ns_ISystemUpdateInterface.sfdl.h>
#include <nn/ns/detail/ns_IVulnerabilityManagerInterface.sfdl.h>
#include <nn/ns/detail/ns_Log.h>

#include "ns_ServiceObjectHolder.h"
#include "ns_Initialize.h"

namespace nn { namespace ns {

    namespace
    {
        sf::ProxyObjectAllocator<16> g_ServiceObjectAllocator = NN_SF_PROXY_OBJECT_ALLOCATOR_INITIALIZER;
        sf::ProxyObjectAllocator<4> g_SystemUpdateServiceObjectAllocator = NN_SF_PROXY_OBJECT_ALLOCATOR_INITIALIZER;

        template<typename InterfaceType, typename ImplType>
        void InitializeWithProxyObjectOrImplObject(ServiceObjectHolder<InterfaceType>* holder, const char* portName, ImplType* implObject, MemoryResource* memoryResource) NN_NOEXCEPT
        {
            auto result = holder->InitializeWithProxyObject(portName, memoryResource);
            if (result.IsFailure())
            {
                holder->InitializeWithImplObject(implObject, memoryResource);
            }
        }

        void InitializeServiceGetterInterface(ServiceObjectHolder<detail::IServiceGetterInterface>* holder) NN_NOEXCEPT
        {
            const char* ports[] = {
                detail::PortNameForEcApplet,
                detail::PortNameForWebApplet,
                detail::PortNameForRetailInteractiveDisplay,
                detail::PortNameForRepairTool,
                detail::PortNameForApplicationManager };

            for(auto port : ports)
            {
                auto result = holder->InitializeWithProxyObject(port, g_ServiceObjectAllocator.GetMemoryResource());
                if (result.IsSuccess())
                {
                    return;
                }
            }
        }
    } // namespace

    void InitializeServiceObjectsImpl(bool abortIfApplicationManagerInitializeFailed, ServiceObjectHolders* holders) NN_NOEXCEPT
    {
        // SystemUpdate, VulnerabilityManager は 必ず ProxyObject からインターフェースを取る。
        holders->systemUpdateInterfaceHolder.InitializeWithProxyObject(detail::PortNameForSystemUpdate, g_SystemUpdateServiceObjectAllocator.GetMemoryResource());
        holders->vulnerabilityManagerInterfaceHolder.InitializeWithProxyObject(detail::PortNameForVulnerabilityManager, g_ServiceObjectAllocator.GetMemoryResource());

        InitializeServiceGetterInterface(&holders->serviceGetterInterfaceHolder);
    }

    void FinalizeServiceObjectsImpl(ServiceObjectHolders* holders) NN_NOEXCEPT
    {
        holders->serviceGetterInterfaceHolder.Finalize();
        holders->vulnerabilityManagerInterfaceHolder.Finalize();
        holders->systemUpdateInterfaceHolder.Finalize();
    }

    MemoryResource* GetMemoryResourceImpl() NN_NOEXCEPT
    {
        return g_ServiceObjectAllocator.GetMemoryResource();
    }

    void InitializeMemoryResourceImpl() NN_NOEXCEPT
    {
        g_ServiceObjectAllocator.Initialize();
        g_SystemUpdateServiceObjectAllocator.Initialize();
    }

    void FinalizeMemoryResourceImpl() NN_NOEXCEPT
    {
        g_SystemUpdateServiceObjectAllocator.Finalize();
        g_ServiceObjectAllocator.Finalize();
    }
}}
