﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <type_traits>
#include <nn/sf/sf_ProxyObjectAllocator.h>
#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_ApplicationManagerInitializeApi.h>
#include <nn/ns/ns_ApplicationManagerSystemApi.h>
#include <nn/ns/ns_EcAppletApi.h>
#include <nn/ns/ns_WebAppletApi.h>
#include <nn/ns/ns_VulnerabilityApi.h>
#include <nn/ns/detail/ns_ISystemUpdateInterface.sfdl.h>
#include <nn/ns/detail/ns_IVulnerabilityManagerInterface.sfdl.h>
#include <nn/ns/detail/ns_Log.h>

#include "ns_ServiceObjectHolder.h"
#include "ns_Initialize.h"

namespace nn { namespace ns {

    namespace
    {
        ServiceObjectHolders g_ServiceObjectHolders;
    } // namespace

    void InitializeServiceObjects(bool abortIfApplicationManagerInitializeFailed) NN_NOEXCEPT
    {
        InitializeMemoryResourceImpl();

        // サービスオブジェクトの初期化処理は実装分岐している
        InitializeServiceObjectsImpl(abortIfApplicationManagerInitializeFailed, &g_ServiceObjectHolders);
    }

    void FinalizeServiceObjects() NN_NOEXCEPT
    {
        FinalizeServiceObjectsImpl(&g_ServiceObjectHolders);
        FinalizeMemoryResourceImpl();
    }

    void InitializeServiceGetterWithObject(nn::sf::SharedPointer<nn::ns::detail::IServiceGetterInterface> serviceObject) NN_NOEXCEPT
    {
        g_ServiceObjectHolders.serviceGetterInterfaceHolder.InitializeDirectly(serviceObject);
    }

    void InitializeForSystemUpdateWithObject(nn::sf::SharedPointer<nn::ns::detail::ISystemUpdateInterface> serviceObject) NN_NOEXCEPT
    {
        g_ServiceObjectHolders.systemUpdateInterfaceHolder.InitializeDirectly(serviceObject);
    }


    detail::IVulnerabilityManagerInterface* GetVulnerabilityManagerInterface() NN_NOEXCEPT
    {
        return g_ServiceObjectHolders.vulnerabilityManagerInterfaceHolder.GetInterfaceObject();
    }

    detail::ISystemUpdateInterface* GetSystemUpdateInterfaceInterface() NN_NOEXCEPT
    {
        return g_ServiceObjectHolders.systemUpdateInterfaceHolder.GetInterfaceObject();
    }

    sf::SharedPointer<detail::IApplicationManagerInterface> GetApplicationManagerInterface() NN_NOEXCEPT
    {
        sf::SharedPointer<detail::IApplicationManagerInterface> p;
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServiceObjectHolders.serviceGetterInterfaceHolder.GetInterfaceObject()->GetApplicationManagerInterface(&p));
        return p;
    }

    sf::SharedPointer<detail::IDocumentInterface> GetDocumentInterface() NN_NOEXCEPT
    {
        sf::SharedPointer<detail::IDocumentInterface> p;
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServiceObjectHolders.serviceGetterInterfaceHolder.GetInterfaceObject()->GetDocumentInterface(&p));
        return p;
    }

    sf::SharedPointer<detail::IContentManagementInterface> GetContentManagementInterface() NN_NOEXCEPT
    {
        sf::SharedPointer<detail::IContentManagementInterface> p;
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServiceObjectHolders.serviceGetterInterfaceHolder.GetInterfaceObject()->GetContentManagementInterface(&p));
        return p;
    }

    sf::SharedPointer<detail::IDownloadTaskInterface> GetDownloadTaskInterface() NN_NOEXCEPT
    {
        sf::SharedPointer<detail::IDownloadTaskInterface> p;
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServiceObjectHolders.serviceGetterInterfaceHolder.GetInterfaceObject()->GetDownloadTaskInterface(&p));
        return p;
    }

    sf::SharedPointer<detail::IAccountProxyInterface> GetAccountProxyInterface() NN_NOEXCEPT
    {
        sf::SharedPointer<detail::IAccountProxyInterface> p;
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServiceObjectHolders.serviceGetterInterfaceHolder.GetInterfaceObject()->GetAccountProxyInterface(&p));
        return p;
    }

    sf::SharedPointer<detail::IFactoryResetInterface> GetFactoryResetInterface() NN_NOEXCEPT
    {
        sf::SharedPointer<detail::IFactoryResetInterface> p;
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServiceObjectHolders.serviceGetterInterfaceHolder.GetInterfaceObject()->GetFactoryResetInterface(&p));
        return p;
    }

    sf::SharedPointer<detail::IApplicationVersionInterface> GetApplicationVersionInterface() NN_NOEXCEPT
    {
        sf::SharedPointer<detail::IApplicationVersionInterface> p;
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServiceObjectHolders.serviceGetterInterfaceHolder.GetInterfaceObject()->GetApplicationVersionInterface(&p));
        return p;
    }

    sf::SharedPointer<detail::IECommerceInterface> GetECommerceInterface() NN_NOEXCEPT
    {
        sf::SharedPointer<detail::IECommerceInterface> p;
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServiceObjectHolders.serviceGetterInterfaceHolder.GetInterfaceObject()->GetECommerceInterface(&p));
        return p;
    }

    sf::SharedPointer<detail::IReadOnlyApplicationRecordInterface> GetReadOnlyApplicationRecordInterface() NN_NOEXCEPT
    {
        sf::SharedPointer<detail::IReadOnlyApplicationRecordInterface> p;
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServiceObjectHolders.serviceGetterInterfaceHolder.GetInterfaceObject()->GetReadOnlyApplicationRecordInterface(&p));
        return p;
    }

    sf::SharedPointer<detail::IReadOnlyApplicationControlDataInterface> GetReadOnlyApplicationControlDataInterface() NN_NOEXCEPT
    {
        sf::SharedPointer<detail::IReadOnlyApplicationControlDataInterface> p;
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServiceObjectHolders.serviceGetterInterfaceHolder.GetInterfaceObject()->GetReadOnlyApplicationControlDataInterface(&p));
        return p;
    }

    sf::SharedPointer<detail::IDynamicRightsInterface> GetDynamicRightsInterface() NN_NOEXCEPT
    {
        sf::SharedPointer<detail::IDynamicRightsInterface> p;
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ServiceObjectHolders.serviceGetterInterfaceHolder.GetInterfaceObject()->GetDynamicRightsInterface(&p));
        return p;
    }
}}
