﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_GameCardRegistrationApi.h>
#include "ns_Initialize.h"
#include <nn/ns/ns_Result.h>
#include <nn/nifm/nifm_ApiClientManagement.h>

namespace nn { namespace ns {
    Result RequestCheckGameCardRegistration(AsyncResult* outValue, ncm::ApplicationId appId) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());

        sf::NativeHandle nativeHandle;
        sf::SharedPointer<detail::IAsyncResult> sp;
        NN_RESULT_DO(GetApplicationManagerInterface()->RequestCheckGameCardRegistration(&nativeHandle, &sp, appId));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

    Result RequestGameCardRegistrationGoldPoint(AsyncGameCardGoldPoint* outValue, const account::Uid& uid, ncm::ApplicationId appId) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());

        sf::NativeHandle nativeHandle;
        sf::SharedPointer<detail::IAsyncValue> sp;
        NN_RESULT_DO(GetApplicationManagerInterface()->RequestGameCardRegistrationGoldPoint(&nativeHandle, &sp, uid, appId));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

    Result RequestRegisterGameCard(AsyncResult* outValue, const account::Uid& uid, ncm::ApplicationId appId, int goldPoint) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());

        sf::NativeHandle nativeHandle;
        sf::SharedPointer<detail::IAsyncResult> sp;
        NN_RESULT_DO(GetApplicationManagerInterface()->RequestRegisterGameCard(&nativeHandle, &sp, uid, appId, goldPoint));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }
}}
