﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/ns/ns_ApplicationManagerSystemApi.h>
#include <nn/ns/ns_GameCardApi.h>
#include <nn/ns/ns_GameCardStopper.h>
#include <nn/ns/ns_Result.h>
#include "ns_Initialize.h"

namespace nn { namespace ns {
    void GetGameCardUpdateDetectionEvent(os::SystemEvent* outValue) NN_NOEXCEPT
    {
        sf::NativeHandle sfHandle;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->GetGameCardUpdateDetectionEvent(sf::Out<sf::NativeHandle>(&sfHandle)));

        outValue->AttachReadableHandle(sfHandle.GetOsHandle(), sfHandle.IsManaged(), os::EventClearMode_ManualClear);
        sfHandle.Detach();
    }

    void GetGameCardAttachmentEvent(os::SystemEvent* pOutEvent) NN_NOEXCEPT
    {
        sf::NativeHandle sfHandle;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->GetGameCardAttachmentEvent(sf::Out<sf::NativeHandle>(&sfHandle)));

        pOutEvent->AttachReadableHandle(sfHandle.GetOsHandle(), sfHandle.IsManaged(), os::EventClearMode_ManualClear);
        sfHandle.Detach();
    }

    void GetGameCardAttachmentInfo(GameCardAttachmentInfo* pOutInfo) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->GetGameCardAttachmentInfo(sf::Out<GameCardAttachmentInfo>(pOutInfo)));
    }

    void GetGameCardStopper(GameCardStopper* outValue) NN_NOEXCEPT
    {
        sf::SharedPointer<detail::IGameCardStopper> interface;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->GetGameCardStopper(&interface));

        *outValue = GameCardStopper(std::move(interface));
    }

    void GetGameCardMountFailureEvent(os::SystemEvent* pOutEvent) NN_NOEXCEPT
    {
        sf::NativeHandle sfHandle;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->GetGameCardMountFailureEvent(sf::Out<sf::NativeHandle>(&sfHandle)));

        pOutEvent->AttachReadableHandle(sfHandle.GetOsHandle(), sfHandle.IsManaged(), os::EventClearMode_ManualClear);
        sfHandle.Detach();
    }

    bool IsGameCardInserted() NN_NOEXCEPT
    {
        bool isInserted;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->IsGameCardInserted(&isInserted));
        return isInserted;
    }

    Result EnsureGameCardAccess() NN_NOEXCEPT
    {
        auto result = GetApplicationManagerInterface()->EnsureGameCardAccess();
        return result;
    }

    Result GetLastGameCardMountFailureResult() NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->GetLastGameCardMountFailureResult();
    }

    Result ListApplicationIdOnGameCard(int* outCount, ncm::ApplicationId* outList, int numList) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->ListApplicationIdOnGameCard(outCount, sf::OutArray<ncm::ApplicationId>(outList, numList));
    }
}}

