﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_DownloadTaskApi.h>
#include <nn/ns/ns_DownloadTaskSystemApi.h>
#include <nn/sf/sf_Types.h>
#include "ns_Initialize.h"

namespace nn { namespace ns {

    void RequestDownloadTaskList() NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetDownloadTaskInterface()->RequestDownloadTaskList());
    }

    void RequestEnsureDownloadTask(AsyncResult* outValue) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        sf::SharedPointer<detail::IAsyncResult> sp;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetDownloadTaskInterface()->RequestEnsureDownloadTask(&nativeHandle, &sp));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();
    }

    Result RequestDownloadTaskListData(AsyncDownloadTaskListData* outValue) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        sf::SharedPointer<detail::IAsyncValue> sp;
        NN_RESULT_DO(GetDownloadTaskInterface()->RequestDownloadTaskListData(&nativeHandle, &sp));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();
        NN_RESULT_SUCCESS;
    }

    int ListDownloadTaskStatus(DownloadTaskStatus outList[], int count) NN_NOEXCEPT
    {
        int outCount;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetDownloadTaskInterface()->ListDownloadTaskStatus(&outCount, sf::OutArray<DownloadTaskStatus>(outList, static_cast<size_t>(count))));
        return outCount;
    }

    void ClearTaskStatusList() NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetDownloadTaskInterface()->ClearTaskStatusList());
    }

    Result TryCommitCurrentApplicationDownloadTask() NN_NOEXCEPT
    {
        NN_RESULT_DO(GetDownloadTaskInterface()->TryCommitCurrentApplicationDownloadTask());
        NN_RESULT_SUCCESS;
    }

    Result TriggerDynamicCommitEvent() NN_NOEXCEPT
    {
        NN_RESULT_DO(GetDownloadTaskInterface()->TriggerDynamicCommitEvent());
        NN_RESULT_SUCCESS;
    }

}}

